% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vimps.R
\name{calc_vimps}
\alias{calc_vimps}
\title{calc_vimps}
\usage{
calc_vimps(
  dat,
  dep_var,
  doms,
  calc_ko = TRUE,
  calc_dom = FALSE,
  num_folds = 10,
  num_kos = 100,
  model_all = normal_model,
  model_subset = one_tree_model,
  mtry = NULL,
  min.node.size = NULL,
  iterations = 500,
  ko_path = NULL,
  results_path = NULL,
  output_file_ko = NULL,
  output_file_dom = NULL
)
}
\arguments{
\item{dat}{A dataframe of data}

\item{dep_var}{The dependent variable in the dat}

\item{doms}{A dataframe of the variables in dat and the domain they belong to}

\item{calc_ko}{True/False to calculate the knock_off importance}

\item{calc_dom}{True/False to calculate the domain importance}

\item{num_folds}{The number of folds to use while calculating the classification threshold for predictions}

\item{num_kos}{The number of sets of knock off variables to create}

\item{model_all}{The model to use in full ensemble mode in calculations}

\item{model_subset}{The model to use sigularly for building ensembles from}

\item{mtry}{The mtry value to use in the random forests}

\item{min.node.size}{The min.node.size value to use in the random forests}

\item{iterations}{Number of trees to build while calculating variable importance}

\item{ko_path}{Where to store the knock off variable sets}

\item{results_path}{Where to store the intermediary results for calculating variable importance}

\item{output_file_ko}{Where to store the results of the knock off variable importance}

\item{output_file_dom}{Where to store the results of the domain variable importance}
}
\value{
List with 1) Threshold for binary class labeling 2) Model metrics using all variables 3) Model metrics using knock-off variables 4) Variable importance with knock-offs
}
\description{
Calculate the variable importance of the domains for a given
dataset
}
\examples{
calc_vimps(
  data.frame(
    X1=c(2,8,3,9,1,4,3,8,0,9,2,8,3,9,1,4,3,8,0,9),
    X2=c(7,2,5,0,9,1,8,8,3,9,7,2,5,0,9,1,8,8,3,9),
    Y=c(0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,1,1,1,1,1)),
 "Y",
 data.frame(domain=c('X1','X2'),
 variable=c('X1','X2')),
 num_folds=2,
 num_kos=1,
 iterations=50)

}
