% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_XAJ.R
\name{XAJ}
\alias{XAJ}
\title{Run Xinanjiang (XAJ) model (three sources, lumped).}
\usage{
XAJ(PREC, EVAP, params, area = dt * 3.6, dt = 24, full.UH = FALSE)
}
\arguments{
\item{PREC}{Time series of precipitation (daily)}

\item{EVAP}{Time series of pan evaporation or potential evapotranspiration
(daily), length must equal to \code{PREC}}

\item{params}{parameters \code{\link[=XAJ.param.range]{XAJ.param.range()}}}

\item{area}{Basin area (km^2).}

\item{dt}{time step (in hour) of the simulation}

\item{full.UH}{Use the unit hydrograph defined by user, rather than the
instantaneous unit hydrograph (IUH) of Nash, for routing
of surface runoff. Default FALSE.}
}
\value{
This function returns a data frame of some common variables of the XAJ
model at each time step, such as evaporation, soil moisture, surface and
underground runoff.
\subsection{The variables of the table including:}{
\itemize{
\item \code{E}  : Total evaporation (mm)
\item \code{EU} : Evaporation (mm) of upper soil layer
\item \code{EL} : Evaporation (mm) of lower soil layer
\item \code{ED} : Evaporation (mm) of deep soil layer
\item \code{W}  : Total soil moisture (mm)
\item \code{WU} : Soil moisture (mm) of upper soil layer
\item \code{WL} : Soil moisture (mm) of lower soil layer
\item \code{WD} : Soil moisture (mm) of deep soil layer
\item \code{R}  : Total runoff (mm) of each time step
\item \code{RS} : Surface runoff (mm) of each time step
\item \code{RI} : Interflow (mm) of each time step
\item \code{RG} : Underground runoff (mm) of each time step
\item \code{Q}  : Total runoff (m^3/s) at the outlet of the basin
\item \code{QS} : Surface runoff (m^3/s) at the outlet of the basin
\item \code{QI} : Interflow runoff (m^3/s) at the outlet of the basin
\item \code{QG} : Underground runoff (m^3/s) at the outlet of the basin
}
}
}
\description{
An R implementation of three-source Xinanjiang model
by Renjun Zhao, used for daily streamflow simulation.
}
\references{
Zhao and Liu, 1995. The Xinanjiang model, Computer Models of Watershed Hydrology,
Water Resources Publication, Highlands Ranch, CO (1995), pp. 215-232
}
