% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VDJphylo.R
\name{VDJphylo}
\alias{VDJphylo}
\title{Infers basic phylogenetic trees of VDJ germlines of interest with basic distance methods.}
\usage{
VDJphylo(species, chain, source, write.fasta, fasta.name, directory.string,
  inference.method)
}
\arguments{
\item{species}{Specifies desired species. Current species options can be found by running unique(VDJgermlines$species) after loading in data(VDJgermlines). "all_species" will select all available species. Species include ("alpaca","bovine","crab_eating_macaque","dog",
"human","mouse","pig","platypus","rabbit",raintrout","rat","rhesus monkey","salmon",
"sheep","zebrafish","atlanticcod","catfish","teleostei","goat","dolphin","mamonkey",
"camel","runny")}

\item{chain}{Specifies the desired chain. "all_chains" will select all chains. The various chains can be listed by running unique(VDJgermlines$chain).Antibody loci start with IG, TCR starts with TR.NExt comes either heavy, light, alpha, beta etc. Examples include IGHD IGHJ IGHV IGIJ IGIV IGKJ IGKV IGLJ IGLV TRAJ TRAV TRBD TRBJ TRBV TRDD TRDJ TRDV TRGJ TRGV}

\item{source}{Specifies from which source the desired chains should be taken from.  Current sources can be found by running unique(VDJgermlines$source) after loading in data(VDJgermlines). IMGT and vgenerepertoire are currently present.}

\item{write.fasta}{A boolean (TRUE / FALSE) value that species if the output sequences should be also written as a fasta file.}

\item{fasta.name}{A string specifying the name of the fasta file. If this is left blank this will be defaulted to "VDJgermlines.fasta". Manually including extension is not needed.}

\item{directory.string}{A string stating the directory that the fasta file should be saved to. If left blank the
fasta file will be stored in the current working directory.}

\item{inference.method}{Specifies the method to be used to infer the phylogenetic tree. Currently includes
"lv" for Levenshtein distance.}
}
\value{
Returns an unrooted tree inferred using the neighbor joining algorithm. Can be viewed by plot(output_tree) after loading ape package.
}
\description{
Infers basic phylogenetic trees of VDJ germlines of interest with basic distance methods.
}
\examples{
VDJphylo(species = "dog",chain = "IGHD",source = "IMGT",write.fasta = FALSE)
}

