% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marker-term.R
\name{marker_term}
\alias{marker_term}
\title{Creates Data for One Type of Marker}
\usage{
marker_term(formula, id, data, time_fixef, time_rng)
}
\arguments{
\item{formula}{a two-sided \code{\link{formula}} with the marker outcome
on the left-hand side and fixed effect covariates on the right-hand
side.}

\item{id}{the variable for the id of each individual.}

\item{data}{a \code{data.frame} or environment to look at up the
variables in.}

\item{time_fixef}{the time-varying fixed effects. See .e.g.
\code{\link{poly_term}}.}

\item{time_rng}{the time-varying random effects. See .e.g.
\code{\link{poly_term}}.}
}
\value{
An object of class \code{marker_term} containing longitudinal data.
}
\description{
Creates Data for One Type of Marker
}
\details{
The \code{time_fixef} should likely not include an intercept as this is
often included in \code{formula}. Use
\code{poly_term(degree = 0, raw = TRUE, intercept = TRUE)} if you want only
a random intercept.
}
\examples{
# load in the data
library(survival)
data(pbc, package = "survival")

# re-scale by year
pbcseq <- transform(pbcseq, day_use = day / 365.25)
pbc <- transform(pbc, time_use = time / 365.25)

# create the marker terms
m1 <- marker_term(
  log(bili) ~ 1, id = id, data = pbcseq,
  time_fixef = bs_term(day_use, df = 5L),
  time_rng = poly_term(day_use, degree = 1L, raw = TRUE, intercept = TRUE))
m2 <- marker_term(
  albumin ~ 1, id = id, data = pbcseq,
  time_fixef = bs_term(day_use, df = 5L),
  time_rng = poly_term(day_use, degree = 1L, raw = TRUE, intercept = TRUE))
}
