% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Unico.r
\name{simulate_data}
\alias{simulate_data}
\title{Simulate data under Unico model assumption}
\usage{
simulate_data(
  n,
  m,
  k,
  p1,
  p2,
  mus_mean = 10,
  mus_std = 2,
  gammas_mean = 1,
  gammas_std = 0.1,
  betas_mean = 1,
  betas_std = 0.1,
  sigmas_lb = 0,
  sigmas_ub = 1,
  taus_std = 0.1,
  log_file = "Unico.log",
  verbose = FALSE
)
}
\arguments{
\item{n}{A positive integer indicating the number of observations to simulate.}

\item{m}{A positive integer indicating the number of features to simulate.}

\item{k}{A positive integer indicating the number of sources to simulate.}

\item{p1}{A non-negative integer indicating the number of source-specific covariates to simulate.}

\item{p2}{A non-negative indicating the number of non-source-specific covariates to simulate.}

\item{mus_mean}{A numerical value indicating the average of the source specific means.}

\item{mus_std}{A positive value indicating the variation of the source specific means across difference sources.}

\item{gammas_mean}{A numerical value indicating the average effect sizes of the source-specific covariates.}

\item{gammas_std}{A non-negative numerical value indicating the variation of the effect sizes of the source-specific covariates.}

\item{betas_mean}{A numerical value indicating the average effect sizes of the non-source-specific covariates.}

\item{betas_std}{A non-negative numerical value indicating the variation of the effect sizes of the non-source-specific covariates.}

\item{sigmas_lb}{A numerical value indicating the lower bound of a uniform distribution from which we sample entries of matrix \code{A} used to construct the feature specific \code{k} by \code{k} variance-covariance matrix.}

\item{sigmas_ub}{A numerical value indicating the upper bound of a uniform distribution from which we sample entries of matrix \code{A} used to construct the feature specific \code{k} by \code{k} variance-covariance matrix.}

\item{taus_std}{non-negative numerical value indicating the variation of the measurement noise across difference features.}

\item{log_file}{A path to an output log file. Note that if the file \code{log_file} already exists then logs will be appended to the end of the file. Set \code{log_file} to \code{NULL} to prevent output from being saved into a file; note that if \code{verbose == FALSE} then no output file will be generated regardless of the value of \code{log_file}.}

\item{verbose}{A logical value indicating whether to print logs.}
}
\value{
A list of simulated model parameters, covariates, observed mixture, and source-specific data.
\item{X}{An \code{m} by \code{n} matrix of the simulated mixture for \code{m} features and \code{n} observations.}
\item{W}{An \code{n} by \code{k} matrix of the weights/proportions of \code{k} source for each of the \code{n} observations.}
\item{C1}{An \code{n} by \code{p1} matrix of the simulated covariates that affect the source-specific values.}
\item{C2}{An \code{n} by \code{p2} matrix of the simulated covariates that affect the mixture values.}
\item{Z}{A \code{k} by \code{m} by \code{n} tensor of the source specific values for each of the \code{k} sources}
\item{mus}{An \code{m} by \code{k} matrix of the mean of each of the \code{m} features for each of the \code{k} sources.}
\item{gammas}{An \code{m} by \code{k*p1} matrix of the effect sizes of the \code{p1} covariates in \code{C1} on each of the \code{m} features in \code{X}, where the first \code{p1} columns are the source-specific effects of the \code{p1} covariates on the first source, the following \code{p1} columns are the source-specific effects on the second source and so on.}
\item{betas}{An \code{m} by \code{p2} matrix of the effect sizes of the \code{p2} covariates in \code{C2} on the mixture values of each of the \code{m} features.}
\item{sigmas}{An \code{m} by \code{k} by \code{k} tensor of the variance-covariance matrix of each of the \code{m} features.}
\item{taus}{An \code{m} by \code{1} matrix of the feature specific variance of the measurement noise for all m features.}
}
\description{
Simulate all model parameters and sample source specific data from multivariate gaussian with full covariance structure.
}
\details{
Simulate data based on the generative model described in function \link{Unico}.
}
\examples{
data = simulate_data(n=100, m=2, k=3, p1=1, p2=1, taus_std=0, log_file=NULL)

}
