% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WLS.R
\name{WLS}
\alias{WLS}
\title{Computes a weighted least squares linear regression 
 on possibly multivariate responses}
\usage{
WLS(Y, X, W)
}
\arguments{
\item{Y}{a numeric matrix, to act as response}

\item{X}{a numeric matrix, to act as covariates}

\item{W}{a numeric matrix, to act as weights}
}
\value{
a vector of regression coefficients
}
\description{
Computes a weighted least squares linear regression 
 on possibly multivariate responses
}
\examples{
 \dontrun{
 DataY = cbind(CCU12_Precip$Precip, CCU12_Precip$TMax);
DataX = cbind(rep(1, length(CCU12_Precip$Precip)), CCU12_Precip$TMin)			
BetaHat.New = WLS(DataY, DataX)
    		}


}
