% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varEst_class3.R
\name{var_Tille}
\alias{var_Tille}
\title{Tillé's Approximate Variance Estimator}
\usage{
var_Tille(y, pik, sample, maxIter = 1000, eps = 1e-05)
}
\arguments{
\item{y}{numeric vector of sample observations}

\item{pik}{numeric vector of first-order inclusion probabilities for all population units}

\item{sample}{Either a numeric vector of length equal to the sample size with
the indices of sample units, or a boolean vector of the same length of \code{pik}, indicating which
units belong to the sample (\code{TRUE} if the unit is in the sample,
\code{FALSE} otherwise.
Only used with estimators of the third class (see Details for more information).}

\item{maxIter}{a scalar indicating the maximum number of iterations for the
fixed-point procedure}

\item{eps}{tolerance value for the convergence of the fixed-point procedure}
}
\value{
a scalar, the estimated variance
}
\description{
Compute an approximate variance estimate using the estimator
proposed by Tillé (1996).
Estimator of class 3, it requires only first-order inclusion probabilities but
for all population units.
}
\keyword{internal}
