% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.haz2tsLMM.R
\name{plot.haz2tsLMM}
\alias{plot.haz2tsLMM}
\title{Plot method for a haz2tsLMM object.}
\usage{
\method{plot}{haz2tsLMM}(
  x,
  plot_grid = NULL,
  which_plot = c("hazard", "covariates", "SE", "slices", "survival", "cumhaz"),
  where_slices = NULL,
  direction = c(NULL, "u", "s"),
  plot_options = list(),
  ...
)
}
\arguments{
\item{x}{The output of the function \code{fit2ts}. This is an object of
class \code{"haz2tsLMM"}.}

\item{plot_grid}{A list containing the parameters to build a new
finer grid of intervals over \code{u} and \code{s} for plotting. This must be of the
form: \code{plot_grid = list(c(umin, umax, du), c(smin, smax, ds))}, where
\code{umin}, \code{umax} and \code{smin}, \code{smax} are the minimum and maximum values
desired for the intervals over \code{u} and \code{s} respectively, and \code{du}, \code{ds} are
distances between intervals over \code{u} and \code{s} respectively. Specifying a new
denser grid is used to evaluate the B-spline bases used for estimation on
such grid and plot the estimated surfaces with a greater level of details.
If not specified, the plotting is done using the same B-splines bases as
for the estimation. The function will check if the parameters for the grid
provided by the user are compatible with those originally used to construct
the B-splines for estimating the model. If not, the grid will be adjusted
accordingly and a warning will be returned. While for objects of class 'haz2ts'
this is an optional input, we strongly recommend to provide the plotting
grid for object of class 'haz2tsLMM', given that evaluation of the B-splines
works a bit differently in LMMsolver.}

\item{which_plot}{The type of plot required. Can be one of \code{"hazard"}
(default), \code{"covariates"}, \code{"SE"}, \code{"slices"}, \code{"survival"} or \code{"cumhaz"}
(see details section).}

\item{where_slices}{A vector of values for the cutting points of the desired
slices of the surface. If \code{which_plot == "slices"}, please provide this
argument. Please also provide this argument in case \verb{which_plot = "survival}
or \verb{which_plot = "cumhaz} and \code{surv_slices = TRUE} or \code{cumhaz_slices = TRUE},
respectively.}

\item{direction}{If \code{which_plot == "slices"}, indicates the direction for
cutting the surface. If \code{u}, then the surface will be cut at the selected
values of \code{u} (indicated by \code{where_slices}), hence obtaining one-dimensional
curves over \code{s}. If \code{s}, then the surface will be cut at the selected values
of \code{s} (indicated by \code{where_slices}), hence obtaining one-dimensional curves
over \code{u}.}

\item{plot_options}{A list with all possible options for any of the plots:
\itemize{
\item \code{loghazard} A Boolean. Default is \code{FALSE}. If \code{FALSE} the function
returns a plot of the hazard surface, if \code{TRUE} the function returns
a plot of the log-hazard surface.
\item \code{log10hazard} A Boolean. Default is \code{FALSE}. If \code{TRUE},
then a log10 hazard surface is plotted.
\item \code{cut_extrapolated} A Boolean. Default is \code{TRUE}. Cuts away the
extrapolated area of the (log-)hazard surface before plotting.
\item \code{tmax} The maximum value of \code{t} that should be plotted.
\item \code{surv_slices} A Boolean. Default is \code{FALSE}. If \code{TRUE} and
\code{which_plot == "survival"}, plot survival curves over the time \code{s} for
selected values of \code{u}, that are cross-sections of the 2D survival surface.
\item \code{cumhaz_slices} A Boolean. Default is \code{FALSE}. If \code{TRUE} and
\code{which_plot == "cumhaz"}, plot cumulative hazards curves over the time \code{s} for
selected values of \code{u}, that are cross-sections of the 2D cumulative hazard surface.
\item \code{midpoints} A Boolean. Default is \code{FALSE}. If \code{TRUE}, the estimated quantities
(hazard, survival, etc.) will be evaluated in the mid-points of the bins
rather than at the extremes. Set to \code{TRUE} if plotting estimated number of
events.
\item \code{col_palette} A function defining the color palette. The default palette
is \code{viridis::rev(plasma())}. Specifying the color palette as a function
allows for greater flexibility than passing the palette as a vector.
We provide an example on how to create a function from any color palette
below.
\item \code{n_shades} The number of color shades to plot, default is 50.
\item \code{breaks} The vector of breaks for the color legend. If \code{n_shades} is provided,
this should be of length \code{n_shades + 1}.
\item \code{show_legend} A Boolean. Default is \code{TRUE}. If \code{FALSE} no legend will be
plotted, useful for multi-panel figures with common legend. Works only
for plots on rectangular grid (i.e. transformed (u,s) plane).
\item \code{main} The title of the plot.
\item \code{xlab} The label of the first time axis (plotted on the x axis).
\item \code{ylab} The label of the second time axis (plotted on the y axis).
\item \code{xlim} A vector with two elements defining the limits of the time scale
on the x axis.
\item \code{ylim} A vector with two elements defining the limits of the time scale
on the y axis.
\item \code{contour_lines} A Boolean. Default is \code{FALSE}. If \code{TRUE} contour
lines are added to the surfaces.
\item \code{contour_col} The color for the contour lines. Default is \code{white}.
\item \code{contour_cex} The magnification to be used for the contour lines.
Default is \code{.8}.
\item \code{contour_nlev} The number of contour levels desired. Default is 10.
\item \code{cex_main} The magnification to be used for the main title, default is 1.2 .
\item \code{cex_lab} The magnification to be used for the axis labels, default is 1 .
\item \code{HR} A Boolean. If \code{TRUE} the HRs with their CIs will be plotted.
Default is \code{FALSE} (plot the \code{beta} with their CIs).
\item \code{symmetric_CI} A Boolean. Default is \code{TRUE}. If a plot of the HRs is
required (\code{HR == TRUE}), then plot symmetrical Confidence Intervals,
based on the SEs for the HRs calculated by delta method.
If \code{FALSE}, then CIs are obtained by exponentiating the CIs for the betas.
\item \code{confidence} The level of confidence for the CIs. Default is .95 (alpha
= 0.05).
\item \code{col_beta} The color for the plot of the covariates' effects.
\item \code{pch} The symbol for plotting the point estimates.
\item \code{lwd} The line width.
}}

\item{\dots}{Further arguments to image.plot or image}
}
\value{
A plot of the fitted model.
}
\description{
\code{plot.haz2tsLMM()} is the plot method for objects of class \code{haz2tsLMM}.
It produces plots of the fitted model with two time scales (see \code{\link[=fit2ts]{fit2ts()}}),
fitted via LMMsolver. The two-dimensional plots are limited to the transformed
plane, that is only plots over \code{u} and \code{s} axes are produced.
}
\details{
The vignette "visualization" presents and discusses all the different
plotting options for the fitted model over two time scales.
In most of the cases, the user will want to visualize the hazard surface over
the two time scales. This can be plotted on the hazard scale, the log-hazard
scale or the log10-hazard scale, by switching to \code{TRUE} the corresponding
argument in \code{plot_options}.
The survival and cumulative hazard functions can be plotted as two-dimensional
surfaces over \code{u} and \code{s} or \code{t} and \code{s}. However, it is also very informative
to plot them as one-dimensional curves over \code{s} (cross-sections or slices).
This is done by selecting \code{which_plot = "survival"} and \code{surv_slices = TRUE}
in \code{plot_options}. Additionally, a vector of values for the cutting points
over the \code{u}-axis should be passed to the argument \code{where_slices}, together
with setting \code{direction = u}.
Similar plot is obtained for the cumulative hazard by selecting \code{which_plot = "cumhaz"},
\code{cumhaz_slices = TRUE}, see examples section.
Please, notice that for the survival function and the cumulative hazard, only
cross-sections of the surface for selected values of \code{u} (over the \code{s} time)
can be plotted.

The function \code{obtainSmoothTrend} from the R-package \code{LMMsolver} is
used here. We refer the interested readers to https://biometris.github.io/LMMsolver/
for more details on \code{LMMsolver} and its usage.
}
\examples{
# Create some fake data - the bare minimum
id <- 1:20
u <- c(5.43, 3.25, 8.15, 5.53, 7.28, 6.61, 5.91, 4.94, 4.25, 3.86, 4.05, 6.86,
       4.94, 4.46, 2.14, 7.56, 5.55, 7.60, 6.46, 4.96)
s <- c(0.44, 4.89, 0.92, 1.81, 2.02, 1.55, 3.16, 6.36, 0.66, 2.02, 1.22, 3.96,
       7.07, 2.91, 3.38, 2.36, 1.74, 0.06, 5.76, 3.00)
ev <- c(1, 0, 0, 1, 0, 1, 0, 1, 1, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 1)#'

fakedata <- as.data.frame(cbind(id, u, s, ev))
fakedata2ts <- prepare_data(u = fakedata$u,
                            s_out = fakedata$s,
                            ev = fakedata$ev,
                            ds = .5)
# Fit a fake model - not optimal smoothing
fakemod <- fit2ts(fakedata2ts,
                  optim_method = "LMMsolver")

 # plot the hazard surface
 plot(fakemod)
 # plot the survival function as one-dimension curves over `s`
 plot(fakemod,
      which_plot = "survival",
      direction = "u",
      where_slices = c(4, 6, 8),
      plot_options = list(
      surv_slices = TRUE
      ))


# Plot cross-sections of the hazard over `s` for selected values of `u`

plot(fakemod,
  which_plot = "slices",
  where_slices = c(4, 6, 8),
  direction = "u",
  plot_options = list(
    main = "Cross-sections of the hazard",
    xlab = "Time",
    ylab = "Hazard"
  )
)


}
