% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid_search_2d.R
\name{grid_search_2d}
\alias{grid_search_2d}
\title{Grid search for the optimal 2ts model}
\usage{
grid_search_2d(
  lru,
  lrs,
  R,
  Y,
  Bu,
  Bs,
  Z = NULL,
  Iu,
  Is,
  Du,
  Ds,
  Wprior = NULL,
  ridge = 0,
  optim_criterion = c("aic", "bic"),
  control_algorithm = list(maxiter = 20, conv_crit = 1e-05, verbose = FALSE, monitor_ev =
    FALSE),
  par_gridsearch = list(plot_aic = FALSE, plot_bic = FALSE, return_aic = TRUE, return_bic
    = TRUE, col = grey.colors(n = 10), plot_contour = FALSE, mark_optimal = TRUE,
    main_aic = "AIC grid", main_bic = "BIC grid")
)
}
\arguments{
\item{lru}{A vector of \code{log_10(rho_u)} values.}

\item{lrs}{A vector of \code{log_10(rho_s)} values.}

\item{R}{A matrix (or 3d-array) of exposure times of dimension nu by ns
(or nu by ns by n).}

\item{Y}{A matrix (or 3d-array) of event counts of dimension nu by ns
(or nu by ns by n).}

\item{Bu}{A matrix of B-splines for the \code{u} time scale of dimension nu by cu.}

\item{Bs}{A matrix of B-splines for the \code{s} time scale of dimension ns by cs.}

\item{Z}{(optional) A regression matrix of covariates values of dimensions
n by p.}

\item{Iu}{An identity matrix of dimension nbu by nbu.}

\item{Is}{An identity matrix of dimension nbs by nbs.}

\item{Du}{The difference matrix over \code{u}.}

\item{Ds}{The difference matrix over \code{s}.}

\item{Wprior}{An optional matrix of a-priori weights.}

\item{ridge}{A ridge penalty parameter: default is 0. This is useful when, in
some cases the algorithm shows convergence problems. In this case, set to a small
number, for example \code{1e-4}.}

\item{optim_criterion}{The criterion to be used for optimization:
\code{"aic"} (default) or \code{"bic"}. BIC penalized model complexity more strongly
than AIC, so that its usage is recommended when a smoother fit is preferable
(see also Camarda, 2012).}

\item{control_algorithm}{A list with optional values for the parameters of
the iterative processes:
\itemize{
\item \code{maxiter} The maximum number of iteration for the IWSL algorithm.
Default is 20.
\item \code{conv_crit} The convergence criteria, expressed as difference between
estimates at iteration i and i+1. Default is \code{1e-5}.
\item \code{verbose} A Boolean. Default is \code{FALSE}. If \code{TRUE} monitors the iteration
process.
\item \code{monitor_ev} A Boolean. Default is \code{FALSE}. If \code{TRUE} monitors the
evaluation of the model over the \code{log_10(rho_s)} values.
}}

\item{par_gridsearch}{A list of parameters for the grid_search:
\itemize{
\item \code{plot_aic} A Boolean. Default is \code{FALSE}. If \code{TRUE}, plot the AIC values
over the grid of \code{log_10(rho_u)} and \code{log_10(rho_s)} values.
\item \code{plot_bic} A Boolean. Default is \code{FALSE}. If \code{TRUE}, plot the BIC values
over the grid of \code{log_10(rho_u)} and \code{log_10(rho_s)} values.
\item \code{return_aic} A Boolean. Default is \code{TRUE}. Return the AIC values.
\item \code{return_bic} A Boolean. Default is \code{TRUE}. Return the BIC values.
\item \code{col} The color palette to be used for the AIC/BIC plot. Default is
\code{grDevices::gray.colors(n=10)}.
\item \code{plot_contour} A Boolean. Default is \code{TRUE}. Adds white contour lines to
the AIC/BIC plot.
\item \code{mark_optimal} A Boolean. Default is \code{TRUE}. If the plot of the AIC or BIC
values is returned, marks the optimal combination of \code{log_10(rho_u)} and
\code{log_10(rho_s)} in the plot.
\item \code{main_aic} The title of the AIC plot. Default is \code{"AIC grid"}.
\item \code{main_bic} The title of the BIC plot. Default is \code{"BIC grid"}.
}}
}
\value{
An object of class \code{h2tsfit} with the following elements:
\itemize{
\item \code{optimal_model} A list containing the results of the optimal model.
\item \code{optimal_logrho} The optimal couple of \code{log_10(rho_u)} and \code{log_10(rho_s)}
values.
\item \code{P_optimal} The optimal penalty matrix P.
\item \code{AIC} (if \code{par_gridsearch$return_aic == TRUE}) The vector of AIC values.
\item \code{BIC} (if \code{par_gridsearch$return_bic == TRUE}) The vector of BIC values.
}
}
\description{
\code{grid_search_2d()} performs a grid search for the minimum
AIC or BIC of the two time scales model.

It finds the optimal values of \code{log_10(rho_u)} and \code{log_10(rho_s)} and
returns the estimated optimal model.
}
\references{
Camarda, C. G. (2012). "MortalitySmooth: An R Package for
Smoothing Poisson Counts with P-Splines."
Journal of Statistical Software, 50(1), 1–24.
https://doi.org/10.18637/jss.v050.i01
}
