# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Multivariate normal density function
#'
#' This function returns the log-density for a multivariate Gaussian distribution.
#' The data must be imputed as a matrix, using e.g., \code{as.matrix}, with each row
#' representing an observation.
#'
#' @param x matrix of observations
#' @param mu mean vector
#' @param sigma positive definite covariance matrix
#' @param logd logical; whether log-density should be returned (default to \code{FALSE})
#' @return density or log-density of the \code{nrow(x)} sample
#' @keywords internal
#' @export
.dmvnorm_arma <- function(x, mu, sigma, logd = FALSE) {
    .Call(`_TruncatedNormal_dmvnorm_arma`, x, mu, sigma, logd)
}

#' Multivariate Student density function
#'
#' This function returns the log-density for a multivariate Student distribution.
#' The data must be imputed as a matrix, using e.g., \code{as.matrix}, with each row
#' representing an observation.
#'
#' @param x matrix of observations
#' @param mu location vector
#' @param sigma positive definite scale matrix
#' @param df degrees of freedom
#' @param logd logical; whether log-density should be returned (default to \code{FALSE})
#' @return density or log-density of the \code{nrow(x)} sample
#' @keywords internal
#' @export
.dmvt_arma <- function(x, mu, sigma, df, logd = FALSE) {
    .Call(`_TruncatedNormal_dmvt_arma`, x, mu, sigma, df, logd)
}

#' Calculate log of Gaussian distribution function accurately
#' 
#' This function returns the probability of a standard Gaussian variate between 
#' the interval \code{a} and \code{b}, avoiding numerical overflow. The function is vectorized
#' and is meant to be used only internally by the package \code{TruncatedNormal}.
#' 
#' @param a vector of lower bound
#' @param b vector of upper bound
#' @param check logical; should checks be performed? 
#' @return a vector of log probability.
#' @keywords internal
#' @useDynLib TruncatedNormal, .registration = TRUE
#' @importFrom Rcpp evalCpp
#' @export
lnNpr <- function(a, b, check = TRUE) {
    .Call(`_TruncatedNormal_lnNpr`, a, b, check)
}

#' Cholesky matrix decomposition with GB ordering
#' 
#' This function computes the Cholesky decomposition of a covariance matrix
#' \code{Sigma} and returns a list containing the permuted bounds for integration. 
#' The prioritization of the variables follow the rule proposed in Gibson, Glasbey and Elston (1994)
#' and reorder variables to have outermost variables with smallest expected values.
#' 
#' The list contains an integer vector \code{perm} with the indices of the permutation, which is such that
#' \code{Sigma(perm, perm) == L \%*\% t(L)}.
#' The permutation scheme is described in Genz and Bretz (2009) in Section 4.1.3, p.37.
#' @param Sigma \code{d} by \code{d} covariance matrix
#' @param l \code{d} vector of lower bounds
#' @param u \code{d} vector of upper bounds
#' @export
#' @keywords internal
#' @return a list with components
#' \itemize{
#' \item \code{L}: Cholesky root
#' \item \code{l}: permuted vector of lower bounds
#' \item \code{u}: permuted vector of upper bounds
#' \item \code{perm}: vector of integers with ordering of permutation
#' }
#' @references Genz, A. and Bretz, F. (2009). Computations of Multivariate Normal and t Probabilities, volume 105. Springer, Dordrecht.
#' @references Gibson G.J., Glasbey C.A. and D.A. Elton (1994).  Monte Carlo evaluation of multivariate normal integrals and sensitivity to variate ordering. In: Dimon et al., Advances in Numerical Methods and Applications, WSP, pp. 120-126.
.cholpermGB <- function(Sigma, l, u) {
    .Call(`_TruncatedNormal_cholpermGB`, Sigma, l, u)
}

#' Cholesky matrix decomposition with GGE ordering
#' 
#' This function computes the Cholesky decomposition of a covariance matrix
#' \code{Sigma} and returns a list containing the permuted bounds for integration. 
#' The prioritization of the variables follow the rule proposed in Gibson, Glasbey and Elston (1994)
#' and reorder variables to have outermost variables with smallest expected values.
#' 
#' The list contains an integer vector \code{perm} with the indices of the permutation, which is such that
#' \code{Sigma(perm, perm) == L \%*\% t(L)}.
#' The permutation scheme is described in Genz and Bretz (2009) in Section 4.1.3, p.37.
#' @param Sigma \code{d} by \code{d} covariance matrix
#' @param l \code{d} vector of lower bounds
#' @param u \code{d} vector of upper bounds
#' @export
#' @keywords internal
#' @return a list with components
#' \itemize{
#' \item \code{L}: Cholesky root
#' \item \code{l}: permuted vector of lower bounds
#' \item \code{u}: permuted vector of upper bounds
#' \item \code{perm}: vector of integers with ordering of permutation
#' }
#' @references Genz, A. and Bretz, F. (2009). Computations of Multivariate Normal and t Probabilities, volume 105. Springer, Dordrecht.
#' @references Gibson G.J., Glasbey C.A. and D.A. Elton (1994).  Monte Carlo evaluation of multivariate normal integrals and sensitivity to variate ordering. In: Dimon et al., Advances in Numerical Methods and Applications, WSP, pp. 120-126.
.cholpermGGE <- function(Sigma, l, u) {
    .Call(`_TruncatedNormal_cholperm`, Sigma, l, u)
}

#' Quantile of truncated Gaussian
#' 
#' The function compute the \code{p}th quantile associated to the truncated standard Gaussian 
#' variate on the interval (\code{l},\code{u}).
#' 
#' @param p vector of probabilities
#' @param l \code{d} vector of lower bounds
#' @param u \code{d} vector of upper bounds
#' @return vector of quantiles
#' @keywords internal
#' @export
Phinv <- function(p, l, u) {
    .Call(`_TruncatedNormal_Phinv`, p, l, u)
}

