% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/series1.R
\name{Series1}
\alias{Series1}
\title{Tri-Hierarchical IBDs using Triangular Association Scheme}
\usage{
Series1(
  v,
  D1 = FALSE,
  D2 = FALSE,
  D3 = FALSE,
  D4 = FALSE,
  D5 = FALSE,
  D6 = FALSE,
  Randomization = FALSE
)
}
\arguments{
\item{v}{Number of treatments, v = nC2 where n>=5}

\item{D1}{Bi-Hierarchical IBD by ignoring blocks}

\item{D2}{Bi-Hierarchical IBD by ignoring sub-blocks}

\item{D3}{Bi-Hierarchical IBD by ignoring sub-sub blocks}

\item{D4}{IBD at block level}

\item{D5}{IBD at sub block level}

\item{D6}{IBD at sub-sub block level}

\item{Randomization}{Randomization of layout of the designs if needed enter TRUE; by default it is FALSE.}
}
\value{
It gives Tri-HIB design and six component designs with canonical efficiency factor in comparison to an orthogonal design.
}
\description{
This function generates Tri-Hierarchical IBDs based on Triangular association scheme. Here, v=nC2, n >=5. We find balanced incomplete block designs (BIBD) at block level and triangular PBIB designs at sub-block level as well as sub-sub block level. Information matrix pertaining to the estimation of treatments effects, canonical efficiency factor in comparison to an orthogonal design and six component designs are provided.
}
\note{
Numbers in the outer most parentheses represents as block elements, second level parentheses as sub block elements and inner most parentheses as sub-sub block elements.
}
\examples{
library(Tri.Hierarchical.IBDs)
Series1(15,D1=TRUE,D2=TRUE,D3=TRUE,D4=TRUE,D5=FALSE,D6=TRUE,Randomization=FALSE)
}
\references{
Preece, D.A. (1967) <https://doi.org/10.1093/biomet/54.3-4.479>."Nested balanced incomplete block designs".
}
