% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TrendInTrend.R
\name{ttpower}
\alias{ttpower}
\title{Power calculation in trend-in-trend design}
\usage{
ttpower(N, time, G, cstat, alpha_t, beta_0, h1.OR, nrep)
}
\arguments{
\item{N}{Sample Size.}

\item{time}{Number of time points.}

\item{G}{Number of CPE strata.}

\item{cstat}{Value of the c-statistic.}

\item{alpha_t}{A scaler that qunatifies the trend in exposure prevalence.}

\item{beta_0}{Intercept of the outcome model.}

\item{h1.OR}{A given odds ratio.}

\item{nrep}{Number of Monte Carlo replicates.}
}
\value{
\item{power}{Power of detecting the given Odds Ratio.}
}
\description{
Monte Carlo power calculation for trend-in-trend design.
}
\examples{
\donttest{
set.seed(123)
ttpower(N=10000,time=10,G=10,cstat=0.75,alpha_t= 0.4,beta_0=-4.3,h1.OR=1.5,nrep=50)
}
}
\references{
Ertefaie A, Small DS, Ji X, Leonard C, Hennessy S (2018). Statistical Power for Trend-in-trend Design. Epidemiology. 29(3), e21–e23.
}
