% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UtilityFunctions.R
\name{dec_angle}
\alias{dec_angle}
\title{Solar Declination in Radians}
\usage{
dec_angle(doy)
}
\arguments{
\item{doy}{\code{numeric} day of year (1-366). This can be obtained from standard date via \code{\link{day_of_year}}.}
}
\value{
\code{numeric} declination angle (radians).
}
\description{
The function calculates solar declination, which is the angular distance of the sun north or south of the earth’s equator, based on the day of year \insertCite{Campbell1998}{TrenchR}.
}
\examples{
  dec_angle(doy = 112)
  dec_angle(doy = 360)

}
\references{
\insertAllCited{}
}
\seealso{
Other utility functions: 
\code{\link{airpressure_from_elev}()},
\code{\link{azimuth_angle}()},
\code{\link{day_of_year}()},
\code{\link{daylength}()},
\code{\link{solar_noon}()},
\code{\link{temperature conversions}},
\code{\link{zenith_angle}()}
}
\concept{utility functions}
