% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/energybalance_functions.R
\name{Qemitted_thermal_radiation}
\alias{Qemitted_thermal_radiation}
\title{Emitted Thermal Radiation}
\usage{
Qemitted_thermal_radiation(
  epsilon = 0.96,
  A,
  psa_dir,
  psa_ref,
  T_b,
  T_g,
  T_sky = NA,
  T_a,
  enclosed = FALSE
)
}
\arguments{
\item{epsilon}{\code{numeric} longwave infrared emissivity of skin (proportion), 0.95 to 1 for most animals \insertCite{Gates1980}{TrenchR}.}

\item{A}{\code{numeric} surface area ((\ifelse{html}{\out{m<sup>2</sup>}}{\eqn{m^2}{ASCII}}).}

\item{psa_dir}{\code{numeric} view factor indicating the proportion of surface area exposed to sky (or enclosure) (0-1)}

\item{psa_ref}{\code{numeric} view factor indicating the proportion surface area exposed to ground (0-1).}

\item{T_b}{\code{numeric} body surface temperature (K).}

\item{T_g}{\code{numeric} ground surface temperature (K).}

\item{T_sky}{\code{numeric} Estimate effective radiant temperature of sky (K)}

\item{T_a}{\code{numeric} ambient air temperature (K), only required if the animal is in an enclosed environment.}

\item{enclosed}{\code{logical} whether the animal is an enclosed environment or not.}
}
\value{
\code{numeric} emitted thermal radiation, \code{Qemit} (W).
}
\description{
The function estimates the net thermal radiation (W) emitted by the surface of an animal \insertCite{Gates1980,Spotila1992}{TrenchR}.
}
\examples{
  Qemitted_thermal_radiation(epsilon  = 0.96,
                             A        = 1,
                             psa_dir  = 0.4,
                             psa_ref  = 0.5,
                             T_b      = 303,
                             T_g      = 293,
                             T_a      = 298,
                             enclosed = FALSE)

}
\references{
\insertAllCited{}
}
\seealso{
Other biophysical models: 
\code{\link{Grashof_number_Gates}()},
\code{\link{Grashof_number}()},
\code{\link{Nusselt_from_Grashof}()},
\code{\link{Nusselt_from_Reynolds}()},
\code{\link{Nusselt_number}()},
\code{\link{Prandtl_number}()},
\code{\link{Qconduction_animal}()},
\code{\link{Qconduction_substrate}()},
\code{\link{Qconvection}()},
\code{\link{Qevaporation}()},
\code{\link{Qmetabolism_from_mass_temp}()},
\code{\link{Qmetabolism_from_mass}()},
\code{\link{Qnet_Gates}()},
\code{\link{Qradiation_absorbed}()},
\code{\link{Qthermal_radiation_absorbed}()},
\code{\link{Reynolds_number}()},
\code{\link{T_sky}()},
\code{\link{Tb_CampbellNorman}()},
\code{\link{Tb_Gates2}()},
\code{\link{Tb_Gates}()},
\code{\link{Tb_butterfly}()},
\code{\link{Tb_grasshopper}()},
\code{\link{Tb_limpetBH}()},
\code{\link{Tb_limpet}()},
\code{\link{Tb_lizard_Fei}()},
\code{\link{Tb_lizard}()},
\code{\link{Tb_mussel}()},
\code{\link{Tb_salamander_humid}()},
\code{\link{Tb_snail}()},
\code{\link{Tbed_mussel}()},
\code{\link{Tsoil}()},
\code{\link{actual_vapor_pressure}()},
\code{\link{boundary_layer_resistance}()},
\code{\link{external_resistance_to_water_vapor_transfer}()},
\code{\link{free_or_forced_convection}()},
\code{\link{heat_transfer_coefficient_approximation}()},
\code{\link{heat_transfer_coefficient_simple}()},
\code{\link{heat_transfer_coefficient}()},
\code{\link{saturation_vapor_pressure}()},
\code{\link{saturation_water_vapor_pressure}()}
}
\concept{biophysical models}
