% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ToothShape.R
\name{ToothShape}
\alias{ToothShape}
\title{ToothShape}
\usage{
ToothShape(
  tooth.core,
  num.land,
  sects_vector,
  cent.out = "E",
  delta = 0.1,
  direction = "c",
  out.sur = NULL,
  inn.sur = NULL
)
}
\arguments{
\item{tooth.core}{list: tooth.core object}

\item{num.land}{numeric: number of landmarks defining each section}

\item{sects_vector}{numeric: number of sections}

\item{cent.out}{how to define the center of each section. The method allowed are "CCA" (center of cortical area), "E" (barycenter of the external outline) and "I" (barycenter of the internal outline)}

\item{delta}{pixel size used to calculate the CCA}

\item{direction}{clockwise if "c", anticlockwise if"a"}

\item{out.sur}{mesh: if provided, the external outlines will be projected back on the surface}

\item{inn.sur}{mesh: if provided, the internal outlines will be projected back on the surface}
}
\value{
out3D num.pointsx3xnum.sect array in which the external outlines are stored

inn3D num.pointsx3xnum.sect array in which the internal outlines are stored

out2D num.pointsx2xnum.sect array in which the external outlines are stored

inn2D num.pointsx2xnum.sect array in which the interal outlines are stored

ALPM_inn array with the coordinates of ALPM coordinates on the external outline

ALPM_out array with the coordinates of ALPM coordinates on the internal outline

mech_length length of the selected region of interest

start percentage of the mechanical length from which the first section is defined

end percentage of the mechanical length from which the last section is defined

centroids of the cross-sections
}
\description{
Tool for the extraction of equiangular landmarks on the entire dental region of interest
}
\examples{
\donttest{
data("URI1_tooth")
require(morphomap)
require(rgl)
Enamel<-URI1_tooth$mesh1
Dentin<-URI1_tooth$mesh2
Pulp<-URI1_tooth$mesh3
outline<-URI1_tooth$outline
set<-URI1_tooth$set

#Unrolling the crown
AlignMeshes<-ToothAlignment(mesh1=Enamel,mesh2=Dentin,mesh3=Pulp,set,outline,analyse = "c")
#Virtual sectioning dentine-pulp
External<-AlignMeshes$almesh1$mesh
Internal<-AlignMeshes$almesh2$mesh
#Define 16 cross-sections from the 30\% to the 90\% along the crown
Core<-ToothCore(External,Internal,num.points = 1000,num.sect =16,
                bio.len = AlignMeshes$length,start=0.3,end=0.9)
Shape<-ToothShape(Core,num.land = 21,sects_vector = NULL,direction = "a")

plot3d(morphomapArray2matrix(Shape$"out3D"),type="s",radius = 0.1,aspect=FALSE,
xlab="x",ylab="y",zlab="z")
plot3d(morphomapArray2matrix(Shape$"inn3D"),type="s",radius = 0.1,aspect=FALSE,
add=TRUE)
wire3d(AlignMeshes$almesh2$mesh,col="white")
wire3d(AlignMeshes$almesh1$mesh,col="violet")

#Unrolling the rooth
AlignMeshes<-ToothAlignment(mesh1=Enamel,mesh2=Dentin,mesh3=Pulp,set,outline,
analyse = "r")
#Virtual sectioning dentine-pulp
External<-AlignMeshes$almesh2$mesh
Internal<-AlignMeshes$almesh3$mesh
#Define 16 cross-sections from the 10\% to the 50\% along the root
Core<-ToothCore(External,Internal,num.points = 1000,num.sect =16,
                bio.len = AlignMeshes$length,start=0.1,end=0.5)
Shape<-ToothShape(Core,num.land = 21,sects_vector = NULL,direction = "a")

plot3d(morphomapArray2matrix(Shape$"out3D"),type="s",radius = 0.1,aspect=FALSE,
xlab="x",ylab="y",zlab="z")
plot3d(morphomapArray2matrix(Shape$"inn3D"),type="s",radius = 0.1,aspect=FALSE,
add=TRUE)
wire3d(AlignMeshes$almesh3$mesh,col="red")
wire3d(AlignMeshes$almesh2$mesh,col="lightblue")
wire3d(AlignMeshes$almesh1$mesh,col="white")
}
}
\author{
Antonio Profico; Mathilde Augoyard
}
