% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/06-announcements.R
\name{format_extracted_data}
\alias{format_extracted_data}
\title{Format extracted announcement data}
\usage{
format_extracted_data(
  data,
  min_date = NULL,
  max_date = NULL,
  convert_coordinates = TRUE
)
}
\arguments{
\item{data}{Data frame with structure from extract_pdf_data.}

\item{min_date}{Minimum date for filtering (YYYY-MM-DD format or Date/POSIXct object).}

\item{max_date}{Maximum date for filtering (YYYY-MM-DD format or Date/POSIXct object).}

\item{convert_coordinates}{Logical. Convert DMS coordinates to decimal.}
}
\value{
Data frame with formatted and filtered announcement data.
}
\description{
Formats and filters data extracted from announcements, converting dates to proper formats
and allowing filtering by date range.
}
\examples{
\dontrun{
formatted_data <- format_extracted_data(raw_data)

filtered_data <- format_extracted_data(
  data = raw_data,
  min_date = "2024-11-01",
  max_date = "2024-12-31"
)
}

}
