% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{check.range_params}
\alias{check.range_params}
\title{Check Correctness of Input Parameters}
\usage{
check.range_params(optimal_params, params_range_min, params_range_max)
}
\arguments{
\item{optimal_params}{Numerical vector of length equal to the number of model parameters. For the 'Adapted Paik et al.'s Model' it can be computed
as: \eqn{n_p = 2L + R + 2}, where \eqn{L} stands for the number of intervals of the time domain and \eqn{R} the number of regressors of the dataset.}

\item{params_range_min}{Numerical vector of length equal to the number of model parameters (\eqn{n_p}) and containing the minimum range for each
parameter.}

\item{params_range_max}{Numerical vector of length equal to the number of model parameters (\eqn{n_p}) and containing the maximum range for each
parameter.}
}
\value{
An error if any condition is not satisfied.
}
\description{
The function controls that the input parameter vector have a length equal to the theoretical one required by the model and that each parameter
properly belongs to its range.
}
\keyword{internal}
