% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SynTC.R
\name{SynTC}
\alias{SynTC}
\title{Synthesizes a tide curve}
\usage{
SynTC(tmodel = NULL, ssdate, sstime, sedate, setime, solar_syn = TRUE)
}
\arguments{
\item{tmodel}{The model you built with BuildTC(). Please see examples.}

\item{ssdate}{Synthesis start date. This indicates the date you want your tide curve to start with.}

\item{sstime}{Synthesis start time. The starting time for your tide table.}

\item{sedate}{Synthesis end date.}

\item{setime}{Synthesis end time.}

\item{solar_syn}{Compute a solar synthesis? Default is TRUE.}
}
\value{
Returns a list with two elements, which are of class data.table and data.frame.
\item{synthesis.lunar}{The lunar synthesis data as a data.table object in UTC.}
\item{tide.curve}{The solar tide curve as a data.table or NULL object (time zone of the observations).}
}
\description{
Synthesizes a tide curve; model built with BuildTC().
}
\examples{
\dontrun{SynTC(tmodel = your_model, ssdate = "2015/12/17", sstime = "00:00:00",
sedate = "2015/12/31", setime = "23:30:00")}

}
\references{
\url{https://www.bsh.de/DE/PUBLIKATIONEN/_Anlagen/Downloads/Meer_und_Umwelt/Berichte-des-BSH/Berichte-des-BSH_50_de.pdf?__blob=publicationFile&v=13/}

\doi{https://doi.org/10.5194/os-15-1363-2019}
}
