% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refactor.R
\name{refactor}
\alias{refactor}
\title{Refactor R Code with AI Assistance}
\usage{
refactor(file, ...)
}
\arguments{
\item{file}{character, file name of a file containing R code to be refactored or a character string containing R code to be refactored}

\item{...}{optional arguments to be passed to the chat_completion function}
}
\value{
The refactored code either to the console (if the input `file` was a character string) or written to a file (if the input was a file name).
}
\description{
This function refactors R code with the assistance of an AI chatbot.
}
\examples{
\dontrun{
# Create a sample R function file
cat("my_sum <- function(a, b) {", "return(a + b)", "}", file = "sample_function.R")

# Refactor the R function and return the output
refactored_function <- refactor(file = "sample_function.R")

# Refactor the R function and write the output to the same file
refactor(file = "sample_function.R")
}
}
