% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_noise.R
\name{add_noise}
\alias{add_noise}
\title{add_noise: Adds noise to any function}
\usage{
add_noise(func, noise = 0, noise_type = "Gauss")
}
\arguments{
\item{func}{Function to add noise to.}

\item{noise}{Standard deviation of Gaussian noise}

\item{noise_type}{Type of noise, only option now is "Gauss" for Gaussian noise.}
}
\value{
A function that has noise
}
\description{
add_noise: Adds noise to any function
}
\examples{
tf <- add_noise(function(x)sin(2*x*pi));curve(tf)
tf <- add_noise(function(x)sin(2*x*pi), noise=.1);curve(tf)
}
