% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpp_core_documents.r, R/RcppExports.R
\name{p_item}
\alias{p_item}
\alias{p_1pl}
\alias{p_2pl}
\alias{p_m_2pl}
\alias{p_3pl}
\alias{p_m_3pl}
\alias{p_pc}
\alias{p_gpc}
\alias{p_m_gpc}
\alias{p_gr}
\alias{p_m_gr}
\alias{array_p_1pl}
\alias{array_p_2pl}
\alias{array_p_m_2pl}
\alias{array_p_3pl}
\alias{array_p_m_3pl}
\alias{array_p_pc}
\alias{array_p_gpc}
\alias{array_p_m_gpc}
\alias{array_p_gr}
\alias{array_p_m_gr}
\title{(C++) Calculate item response probability}
\usage{
p_1pl(x, b)

p_2pl(x, a, b)

p_m_2pl(x, a, d)

p_3pl(x, a, b, c)

p_m_3pl(x, a, d, c)

p_pc(x, b)

p_gpc(x, a, b)

p_m_gpc(x, a, d)

p_gr(x, a, b)

p_m_gr(x, a, d)

array_p_1pl(x, b)

array_p_2pl(x, a, b)

array_p_m_2pl(x, a, d)

array_p_3pl(x, a, b, c)

array_p_m_3pl(x, a, d, c)

array_p_pc(x, b)

array_p_gpc(x, a, b)

array_p_m_gpc(x, a, d)

array_p_gr(x, a, b)

array_p_m_gr(x, a, d)
}
\arguments{
\item{x}{the theta value. The number of columns should correspond to the number of dimensions.
For \code{array_*()} functions, the number of theta values must correspond to the number of rows.}

\item{b, d}{the difficulty parameter. \code{b} is used for unidimensional items, and \code{d} is used for multidimensional items.}

\item{a}{the \emph{a}-parameter.}

\item{c}{the \emph{c}-parameter.}
}
\description{
\code{p_*()} and \code{array_p_*()} are C++ functions for calculating item response probability.
}
\details{
\code{p_*()} functions accept a single theta value, and \code{array_p_*()} functions accept multiple theta values.

Supports unidimensional and multidimensional models.

\itemize{
  \item{\code{p_1pl()}, \code{array_p_1pl()}}: 1PL models
  \item{\code{p_2pl()}, \code{array_p_2pl()}}: 2PL models
  \item{\code{p_3pl()}, \code{array_p_3pl()}}: 3PL models
  \item{\code{p_pc()}, \code{array_p_pc()}}: PC (partial credit) models
  \item{\code{p_gpc()}, \code{array_p_gpc()}}: GPC (generalized partial credit) models
  \item{\code{p_gr()}, \code{array_p_gr()}}: GR (graded response) models
  \item{\code{p_m_2pl()}, \code{array_p_m_2pl()}}: multidimensional 2PL models
  \item{\code{p_m_3pl()}, \code{array_p_m_3pl()}}: multidimensional 3PL models
  \item{\code{p_m_gpc()}, \code{array_p_m_gpc()}}: multidimensional GPC models
  \item{\code{p_m_gr()}, \code{array_p_m_gr()}}: multidimensional GR models
}
}
\examples{
x <- 0.5

p_1pl(x, 1)
p_2pl(x, 1, 2)
p_3pl(x, 1, 2, 0.25)
p_pc(x, c(0, 1))
p_gpc(x, 2, c(0, 1))
p_gr(x, 2, c(0, 2))

x <- matrix(seq(0.1, 0.5, 0.1)) # three theta values, unidimensional

array_p_1pl(x, 1)
array_p_2pl(x, 1, 2)
array_p_3pl(x, 1, 2, 0.25)
array_p_pc(x, c(0, 1))
array_p_gpc(x, 2, c(0, 1))
array_p_gr(x, 2, c(0, 2))

}
\references{
Rasch, G. (1960). \emph{Probabilistic models for some intelligence and attainment tests.}
Copenhagen: Danish Institute for Educational Research.

Lord, F. M. (1952). A theory of test scores (Psychometric Monograph No. 7). Richmond, VA: Psychometric Corporation.

Birnbaum, A. (1957). \emph{Efficient design and use of tests of mental ability for various decision-making problems}
(Series Report No. 58-16. Project No. 7755-23).
Randolph Air Force Base, TX: USAF School of Aviation Medicine.

Birnbaum, A. (1958). \emph{On the estimation of mental ability}
(Series Report No. 15. Project No. 7755-23).
Randolph Air Force Base, TX: USAF School of Aviation Medicine.

Birnbaum, A. (1958). \emph{Further considerations of efficiency in tests of a mental ability}
(Series Report No. 17. Project No. 7755-23).
Randolph Air Force Base, TX: USAF School of Aviation Medicine.

Birnbaum, A. (1968). Some latent trait models and their use in inferring an examinee's ability.
In Lord, F. M., Novick, M. R. (eds.), \emph{Statistical Theories of Mental Test Scores}, 397-479.
Reading, MA: Addison-Wesley.

Masters, G. N. (1982). A Rasch model for partial credit scoring.
\emph{Psychometrika, 47}(2), 149-174.

Andrich, D. (1978). A rating formulation for ordered response categories.
\emph{Psychometrika, 43}(4), 561-573.

Muraki, E. (1992). A generalized partial credit model: Application of an EM algorithm.
\emph{Applied Psychological Measurement, 16}(2), 159-176.

Samejima, F. (1969). Estimation of latent ability using a response pattern of graded scores.
\emph{Psychometrika Monograph, 17}.
}
