% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayes_functions.R
\name{lnHyperPars}
\alias{lnHyperPars}
\title{Convert mean and standard deviation into log-normal distribution parameters}
\usage{
lnHyperPars(mean, sd)
}
\arguments{
\item{mean}{the desired mean.}

\item{sd}{the desired standard deviation.}
}
\value{
\code{\link{lnHyperPars}} returns two values. These can be directly supplied to \code{\link{rlnorm}}.
}
\description{
\code{\link{lnHyperPars}} is a function for calculating parameters for a log-normal distribution, such that the distribution yields desired mean and standard deviation.
Used for sampling the a-parameter.
}
\examples{
pars <- lnHyperPars(2, 4)
x <- rlnorm(1000000, pars[1], pars[2])
mean(x) # close to 2
sd(x)   # close to 4

}
