% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eligibility_functions.R
\name{assemblyInFinalThetaSegmentWasFeasibleAtLeastOnceInInterimThetaSegments}
\alias{assemblyInFinalThetaSegmentWasFeasibleAtLeastOnceInInterimThetaSegments}
\title{(Internal) Determine if shadowtest assembly was feasible for exposure control purposes}
\usage{
assemblyInFinalThetaSegmentWasFeasibleAtLeastOnceInInterimThetaSegments(
  x,
  final_theta_segment
)
}
\arguments{
\item{x}{an \code{\linkS4class{output_Shadow}} object, containing data for a single examinee.}

\item{final_theta_segment}{the segment the final theta estimate belonged to.}
}
\value{
\code{\link{assemblyInFinalThetaSegmentWasFeasibleAtLeastOnceInInterimThetaSegments}}
returns \code{TRUE} or \code{FALSE}.
}
\description{
\code{\link{assemblyInFinalThetaSegmentWasFeasibleAtLeastOnceInInterimThetaSegments}}
is an internal function for determining if shadowtest assembly was feasible for exposure control purposes.
Specifically, for the segment \emph{k} the final theta estimate belonged to,
it returns \code{TRUE} if shadowtest assembly was feasible at any interim theta that also belonged to \emph{k},
and returns \code{FALSE} otherwise.
}
\details{
Example 1:
\itemize{
  \item{Interim theta segments are \code{1, 2, 3, 4, 5, 1, 2, 3, 4, 5}}
  \item{Shadowtest feasibility are \code{1, 1, 1, 0, 0, 1, 0, 0, 0, 0}}
  \item{Final theta estimate is in segment \code{3}}
  \item{From the two vectors, segments where shadowtest assembly was feasible: \code{1, 2, 3, 1}}
  \item{Final theta segment \code{3} is an element of the above vector. Return \code{TRUE}}
}

Example 2:
\itemize{
  \item{Interim theta segments are \code{1, 2, 3, 4, 5, 1, 2, 3, 4, 5}}
  \item{Shadowtest feasibility are \code{1, 1, 1, 0, 0, 1, 0, 0, 0, 0}}
  \item{Final theta estimate is in segment \code{4}}
  \item{From the two vectors, segments where shadowtest assembly was feasible: \code{1, 2, 3, 1}}
  \item{Final theta segment \code{4} is not an element of the above vector. Return \code{FALSE}}
}
}
\keyword{internal}
