% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eligibility_functions.R
\name{applyEligibilityConstraintsToInfo}
\alias{applyEligibilityConstraintsToInfo}
\title{(Internal) Modify item information using eligibility constraints}
\usage{
applyEligibilityConstraintsToInfo(
  info,
  eligibility_flag_in_current_theta_segment,
  config,
  simulation_constants
)
}
\arguments{
\item{info}{a length-\emph{ni} vector containing item information on each item, intended for shadow-test assembly.}

\item{eligibility_flag_in_current_theta_segment}{a list containing eligibility flags for the current theta segment.}

\item{config}{a \code{\linkS4class{config_Shadow}} object. Use \code{\link{createShadowTestConfig}} for this.}

\item{simulation_constants}{a named list containing simulation constants.}
}
\value{
\code{\link{applyEligibilityConstraintsToInfo}} returns an updated item information vector.
}
\description{
\code{\link{applyEligibilityConstraintsToInfo}} is an internal function for modifying item information using eligibility constraints.
This is known as the big M method.
The function penalizes item information of items that are marked as ineligibile.
This leads to those items being deterred from selected in shadowtest assembly, unless necessary.
}
\keyword{internal}
