% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eligibility_functions.R
\name{adjustAlphaToReduceSpike}
\alias{adjustAlphaToReduceSpike}
\title{(Internal) Apply spike-reduction mechanism on exposure rates}
\usage{
adjustAlphaToReduceSpike(
  exposure_record,
  segment_prob_of_final_theta,
  segments_visited,
  eligibility_flag_in_final_theta_segment,
  x,
  simulation_constants
)
}
\arguments{
\item{exposure_record}{a named list containing exposure records.}

\item{segment_prob_of_final_theta}{the certainty that the final theta estimate
belongs in the segment for the final theta estimate. This is \code{1} when exposure control method is
\code{ELIGIBILITY, BIGM}, and a probability when exposure control method is \code{BIGM-BAYESIAN}.}

\item{segments_visited}{visited segments. This means a set of all segments
that all interim theta estimates for this examinee belonged to. The segment
that the final theta estimate belonged to is not considered a visited segment.}

\item{eligibility_flag_in_final_theta_segment}{a named list containing eligibility flags
in the segment the final theta estimate belongs to.}

\item{x}{an \code{\linkS4class{output_Shadow}} object, containing data for a single examinee.}

\item{simulation_constants}{a named list containing simulation constants.}
}
\value{
\code{\link{clipEligibilityRates}} returns an updated exposure record.
}
\description{
\code{\link{adjustAlphaToReduceSpike}} is an internal function for
applying spike-reduction mechanism on exposure rates.
}
\keyword{internal}
