% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basicfcts_TS_extended.R
\name{dGTS}
\alias{dGTS}
\title{Density function of generalized classical tempered stable distribution}
\usage{
dGTS(
  x,
  alphap = NULL,
  alpham = NULL,
  deltap = NULL,
  deltam = NULL,
  lambdap = NULL,
  lambdam = NULL,
  mu = NULL,
  theta = NULL,
  dens_method = "FFT",
  a = -20,
  b = 20,
  nf = 2048
)
}
\arguments{
\item{x}{A numeric vector of positive quantiles.}

\item{alphap, alpham}{Stability parameter. A real number between 0 and 2.}

\item{deltap, deltam}{Scale parameter. A real number > 0.}

\item{lambdap, lambdam}{Tempering parameter. A real number > 0.}

\item{mu}{A location parameter, any real number.}

\item{theta}{Parameters stacked as a vector.}

\item{dens_method}{A method to get the density function. Here, only "FFT" is
available.}

\item{a}{Starting point of FFT, if \code{dens_method == "FFT"}. -20
by default.}

\item{b}{Ending point of FFT, if \code{dens_method == "FFT"}. 20
by default.}

\item{nf}{Pieces the transformation is divided in. Limited to power-of-two
size. Default is 2048.}
}
\value{
As \code{q} is a numeric vector, the return value is also a numeric
vector of probabilities.
}
\description{
The probability density function (PDF) of the generalized classical tempered
stable (GTS) distributions is not available in closed form.
Relies on fast Fourier transform (FFT) applied to the characteristic
function.
}
\examples{
x <- seq(-5,5,0.25)
y <- dGTS(x,0.3,0.2,1,1,1,1,0)

}
