% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/E.UC.R
\name{E.UC}
\alias{E.UC}
\title{Estimation of the Population Total and its variance using the Ultimate Cluster technique}
\usage{
E.UC(S, PSU, dk, y)
}
\arguments{
\item{S}{Vector identifying the membership to the strata of each unit in selected sample.}

\item{PSU}{Vector identifying the membership to the strata of 
each unit in the population.}

\item{dk}{Sampling weights of the units in the sample.}

\item{y}{Vector, matrix or data frame containig the recollected 
information of the variables of interest for every unit in the 
selected sample.}
}
\value{
This function returns the estimation of the population total of 
every single variable of interest, its estimated standard error 
and its estimated coefficient of variation.
}
\description{
This function computes a weighted estimator of the population total and
estimates its variance by using the Ultimate Cluster technique. This approximation
performs well in many sampling designs. The user specifically needs to
declare the variables of interest, the primary sampling units, the strata, and 
the sampling weights for every singlt unit in the sample.
}
\details{
The function returns a data matrix whose columns correspond to 
the estimated parameters of the variables of interest.
}
\examples{

#############################
## Example 1:              ##
## Stratified Two-stage SI ##
#############################

data('BigCity')
FrameI <- BigCity \%>\% group_by(PSU) \%>\%
summarise(Stratum = unique(Stratum),
          Persons = n(),
          Income = sum(Income),
          Expenditure = sum(Expenditure))
            
attach(FrameI)

sizes = FrameI \%>\% group_by(Stratum) \%>\%
        summarise(NIh = n(),
        nIh = 2,
        dI = NIh/nIh)
        
NIh <- sizes$NIh
nIh <- sizes$nIh

samI <- S.STSI(Stratum, NIh, nIh)
UI <- levels(as.factor(FrameI$PSU))
sampleI <- UI[samI]
          
FrameII <- left_join(sizes, BigCity[which(BigCity$PSU \%in\% sampleI), ])
attach(FrameII)

HHdb <- FrameII \%>\% 
        group_by(PSU) \%>\%
        summarise(Ni = length(unique(HHID)))
        
Ni <- as.numeric(HHdb$Ni)
ni <- ceiling(Ni * 0.1)
ni
sum(ni)

sam = S.SI(Ni[1], ni[1])
clusterII = FrameII[which(FrameII$PSU == sampleI[1]), ]
sam.HH <- data.frame(HHID = unique(clusterII$HHID)[sam])
clusterHH <- left_join(sam.HH, clusterII, by = "HHID") 
clusterHH$dki <- Ni[1]/ni[1]
clusterHH$dk <- clusterHH$dI * clusterHH$dki
data = clusterHH
for (i in 2:length(Ni)) {
      sam = S.SI(Ni[i], ni[i])
      clusterII = FrameII[which(FrameII$PSU == sampleI[i]), ]
      sam.HH <- data.frame(HHID = unique(clusterII$HHID)[sam])
      clusterHH <- left_join(sam.HH, clusterII, by = "HHID") 
      clusterHH$dki <- Ni[i]/ni[i]
      clusterHH$dk <- clusterHH$dI * clusterHH$dki
      data1 = clusterHH
      data = rbind(data, data1)
}

sum(data$dk)
attach(data)
estima <- data.frame(Income, Expenditure)
area <- as.factor(PSU)
stratum <- as.factor(Stratum)

E.UC(stratum, area, dk, estima)

################################
## Example 2:                 ##
## Self weighted Two-stage SI ##
################################

data('BigCity')
FrameI <- BigCity \%>\% group_by(PSU) \%>\%
summarise(Stratum = unique(Stratum),
          Households = length(unique(HHID)),
          Income = sum(Income),
          Expenditure = sum(Expenditure))
            
attach(FrameI)

sizes = FrameI \%>\% group_by(Stratum) \%>\%
        summarise(NIh = n(),
        nIh = 2)
        
NIh <- sizes$NIh
nIh <- sizes$nIh

resI <- S.STpiPS(Stratum, Households, nIh)
head(resI)
samI <- resI[, 1]
piI <- resI[, 2]
UI <- levels(as.factor(FrameI$PSU))
sampleI <- data.frame(PSU = UI[samI], dI = 1/piI) 
 
FrameII <- left_join(sampleI, 
           BigCity[which(BigCity$PSU \%in\% sampleI[,1]), ])
           
attach(FrameII)

HHdb <- FrameII \%>\% 
        group_by(PSU) \%>\%
        summarise(Ni = length(unique(HHID)))
Ni <- as.numeric(HHdb$Ni)
ni <- 5

sam = S.SI(Ni[1], ni)
clusterII = FrameII[which(FrameII$PSU == sampleI$PSU[1]), ]
sam.HH <- data.frame(HHID = unique(clusterII$HHID)[sam])
clusterHH <- left_join(sam.HH, clusterII, by = "HHID") 
clusterHH$dki <- Ni[1]/ni
clusterHH$dk <- clusterHH$dI * clusterHH$dki
data = clusterHH
for (i in 2:length(Ni)) {
      sam = S.SI(Ni[i], ni)
      clusterII = FrameII[which(FrameII$PSU == sampleI$PSU[i]), ]
      sam.HH <- data.frame(HHID = unique(clusterII$HHID)[sam])
      clusterHH <- left_join(sam.HH, clusterII, by = "HHID") 
      clusterHH$dki <- Ni[i]/ni
      clusterHH$dk <- clusterHH$dI * clusterHH$dki
      data1 = clusterHH
      data = rbind(data, data1)
}

sum(data$dk)
attach(data)
estima <- data.frame(Income, Expenditure)
area <- as.factor(PSU)
stratum <- as.factor(Stratum)

E.UC(stratum, area, dk, estima)
}
\references{
Sarndal, C-E. and Swensson, B. and Wretman, J. (1992), \emph{Model Assisted Survey Sampling}. Springer.\cr
Gutierrez, H. A. (2009), \emph{Estrategias de muestreo: Diseno de encuestas y estimacion de parametros}. Editorial Universidad Santo Tomas
}
\seealso{
\code{\link{E.2SI}}
}
\author{
Hsugo Andres Gutierrez Rojas <hugogutierrez at gmail.com>
}
