% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc-doc.R
\docType{data}
\name{tourism}
\alias{tourism}
\title{Tourism competition data}
\format{A list of 1311 series, of class \code{Mcomp}.  Each series within \code{tourism} is of 
class \code{Mdata} with the following structure:
   \describe{
\item{sn}{Name of the series}
\item{st}{Series number and period. For example "Y1" denotes
first yearly series, "Q20" denotes 20th quarterly series and so on.}
\item{n}{The number of observations in the time series}
\item{h}{The number of required forecasts}
\item{period}{Interval of the time series. Possible values are "YEARLY", "QUARTERLY" &
"MONTHLY"}
\item{type}{The type of series. For data in \code{tourism}, this is always "TOURISM".}
\item{description}{"No description available".  Kept for consistency with the M3 and M1 data.}
\item{x}{A time series of length \code{n} (the historical data)}
\item{xx}{A time series of length \code{h} (the future data)}
}}
\source{
\url{http://robjhyndman.com/papers/the-tourism-forecasting-competition}
}
\usage{
tourism
}
\description{
The data from the tourism forecasting competition described
in George Athanasopolous, Rob J. Hyndman, Haiyan Song, Doris C. Wu (2011) 
``The tourism forecasting competition'', \emph{International Journal of Forecasting} 27 (2011) 822-844.
}
\examples{
plot(tourism$Y1)
}
\seealso{
\code{\link[Mcomp]{subset.Mcomp}}, \code{\link[Mcomp]{plot.Mdata}}
}
\keyword{datasets}
