% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LRTTRBoot.R
\name{LRTTRBoot}
\alias{LRTTRBoot}
\title{The robust likelihood ratio test parametric bootstrap with trace test (RTLRPBT).}
\usage{
LRTTRBoot(X, mu0, B)
}
\arguments{
\item{X}{a matrix n x p containing n observations and p variables. It should not contain missing values (NA).}

\item{mu0}{a vector containing the mean population to be tested.}

\item{B}{the number of resamples bootstrap parametric which must be at least equal to 2000.}
}
\value{
the numerical value and the p-value of the test statistic.
}
\description{
An robust alternative test version of the likelihood ratio test (LRT) parametric bootstrap with trace (RTLPBT) to test the hypotheses about a vector of population averages using the comedian robust estimator. This test has the advantage of being valid for high dimension data (n <p)
}
\examples{
set.seed(0)
library(MASS)
n <- 30
p <- 2
rho <- 0.9
delta <- 0.9
mu <- rep(0, times  = p)
Sigma <- (1 - rho) * diag(p) + rho * matrix(1, p, p)
mu0 <- rep(0.3271,times = p)
B <- 200
X <- mvrnorm(n, mu, Sigma)
LRTTRBoot(X=X, mu0=mu0, B=B)

}
