% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tauvalue.R
\name{tauvalue}
\alias{tauvalue}
\title{\eqn{\tau}-value}
\usage{
tauvalue(v, binary = FALSE)
}
\arguments{
\item{v}{A characteristic function, as a vector.}

\item{binary}{A logical value. By default, \code{binary=FALSE}. Should be set to \code{TRUE} if \code{v} is introduced in binary order instead of lexicographic order.}
}
\value{
The \eqn{\tau}-value of the game, as a vector.
}
\description{
Given a game, this function computes its \eqn{\tau}-value.
}
\details{
The \eqn{\tau}-value of \eqn{v\in G^N} is given by
\deqn{\tau(v)=m(v)+\alpha (M(v)-m(v)),}
where \eqn{M(v)} is the vector of utopia payoffs, \eqn{m(v)} is the vector of minimal rights, and \eqn{\alpha} is the value for which \eqn{\sum_{i\in N}\tau_i(v)=v(N)}.
}
\examples{
tauvalue(c(0,0,0,0,10,40,30,60,10,20,90,90,90,130,160))

# What if the game is a cost game?
cost.v <- c(2,2,2,3,4,4,5) # cost game
-tauvalue(-cost.v) # tau-value of the cost game
}
\references{
Tijs, S. H. (1981). Bounds for the core of a game and the \eqn{\tau}-value. In O. Moeschlin and D. Pallaschke (Eds.), \emph{Game theory and mathematical economics} (pp. 123-132).
}
\seealso{
\link{minimalrightsvector}, \link{utopiapayoffsvector}.
}
