% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prenucleolusvalue.R
\name{prenucleolusvalue}
\alias{prenucleolusvalue}
\title{Prenucleolus}
\usage{
prenucleolusvalue(v, binary = FALSE, tol = 100 * .Machine$double.eps)
}
\arguments{
\item{v}{A characteristic function, as a vector.}

\item{binary}{A logical value. By default, \code{binary=FALSE}. Should be set to \code{TRUE} if \code{v} is introduced in binary order instead of lexicographic order.}

\item{tol}{A tolerance parameter, as a non-negative number.\cr
By default, \code{tol=100*.Machine$double.eps}.}
}
\value{
The prenucleolus of the game, as a vector.
}
\description{
Given a game, this function computes its prenucleolus.
}
\details{
Given a game \eqn{v\in G^N} and an allocation \eqn{x}, the excess of coalition \eqn{S \in 2^N}
with respect to \eqn{x} is defined as \eqn{e(v,x,S)=v(S)-x(S)}, where \eqn{x(S)=\sum_{i\in S} x_i}.
Let \eqn{\theta(x)} be a vector of excesses at \eqn{x} arranged in non-increasing order.
It is said that a vector \eqn{\alpha} is lexicographically greater than another vector \eqn{\beta}
if \eqn{\alpha \neq \beta} and the first non-zero coordinate of vector \eqn{\alpha-\beta} is positive.

The prenucleolus is the set of the efficient allocations that produce a lexicographically minimal vector of excesses.
It is always non-empty and it actually comprises a single allocation,
which in zero-monotonic games coincides with the nucleolus.

The implementation of this function is based on the algorithm presented in Derks and Kuipers (1997) and on the MATLAB package WCGT2005 by J. Derks.
}
\examples{
prenucleolusvalue(c(0,0,0,0,10,40,30,60,10,20,90,90,90,130,160))
v <- runif(2^6-1, min = 10, max = 20) # random 6-player game
prenucleolusvalue(v)

# The prenucleolus of v must pass the Kohlberg criterion.
# In some cases, though, the tolerance might have to be adjusted
# to avoid numerical error:
kohlbergcriterion(v,prenucleolusvalue(v))
kohlbergcriterion(v,prenucleolusvalue(v),tol=10^(-6))

# What if the game is a cost game?
cost.v <- c(2,2,2,3,4,4,5) # cost game
-prenucleolusvalue(-cost.v) # prenucleolus of the cost game
}
\references{
Derks, J. & Kuipers, J. (1997). Implementing the simplex method for computing the prenucleolus of transferable utility games.

Schmeider, D. (1969). The Nucleolus of a Characteristic Function Game. \emph{SIAM Journal on Applied Mathematics}, 17(6), 1163–1170.

Software by J. Derks (Copyright 2005 Universiteit Maastricht, dept. of Mathematics), available in package \emph{MatTuGames},

            \url{https://www.shorturl.at/i6aTF}.
}
\seealso{
\link{excesses}, \link{kohlbergcriterion}, \link{leastcore}, \link{nucleoluspcvalue}, \link{nucleolusvalue}
}
