% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/essentialcheck.R
\name{essentialcheck}
\alias{essentialcheck}
\title{Essential check}
\usage{
essentialcheck(v, binary = FALSE)
}
\arguments{
\item{v}{A characteristic function, as a vector.}

\item{binary}{A logical value. By default, \code{binary=FALSE}. Should be set to \code{TRUE} if \code{v} is introduced in binary order instead of lexicographic order.}
}
\value{
\code{TRUE} if the game is essential, \code{FALSE} otherwise.
}
\description{
This function checks if the given game is essential.
}
\details{
A game \eqn{v\in G^N} is essential if its set of imputations is non-empty, that is,
if \eqn{v(N)\ge \sum_{i \in N} v(i)}.
}
\examples{
v <- c(0, 0, 0, 2, 3, 4, 1)
essentialcheck(v, binary = TRUE)
essentialcheck(v, binary = FALSE)

# What if the game is a cost game?
cost.v <- c(2,2,2,3,4,4,5) # essential cost game
essentialcheck(-cost.v)
}
\seealso{
\link{degeneratecheck}
}
