#' @title Normalized game
#' @description Given a game, this function returns the characteristic function of its 0-1-normalization, its 0-(-1) normalization or its 0-0 normalization, as appropriate.
#' @param v A characteristic function, as a vector.
#' @param binary A logical value. By default, \code{binary=FALSE}. Should be set to \code{TRUE} if \code{v} is introduced in binary order instead of lexicographic order.
#' @return  The characteristic function of the 0-1-normalized game, the 0-(-1) normalized game or the 0-0 normalized game; as a vector in binary order if \code{binary=TRUE} and in lexicographic order otherwise.
#' @details A game \eqn{v\in G^N} is: 0-1 normalized if \eqn{v(i)=0} for all \eqn{i\in N} and \eqn{v(N)=1};
#' 0-0 normalized if \eqn{v(i)=0} for all \eqn{i\in N} and \eqn{v(N)=0};
#' and 0-(-1) normalized if \eqn{v(i)=0} for all \eqn{i\in N} and \eqn{v(N)=-1}.
#'
#' If \eqn{v(N)>\sum_{i\in N}v(i)}, the 0-1 normalized game of \eqn{v}, \eqn{v_{0,1}\in G^N}, is  defined by
#' \deqn{v_{0,1}(S)=\frac{v(S)-\sum_{i\in S}v(i)}{v(N)-\sum_{i\in N}v(i)}} for all \eqn{S\in 2^N}.
#'
#' If \eqn{v(N)<\sum_{i\in N}v(i)}, the 0-(-1) normalized game of \eqn{v}, \eqn{v_{0,-1}\in G^N}, is  defined by
#' \deqn{v_{0,-1}(S)=-\frac{v(S)-\sum_{i\in S}v(i)}{v(N)-\sum_{i\in N}v(i)}} for all \eqn{S\in 2^N}.
#'
#' If \eqn{v(N)=\sum_{i\in N}v(i)}, the 0-0 normalized game of \eqn{v}, \eqn{v_{0,0}\in G^N}, is  defined by
#' \deqn{v_{0,0}(S)=v(S)-\sum_{i\in S}v(i)} for all \eqn{S\in 2^N}.
#' @examples
#' v <- c(1, 5, 11, 6, 11, 15, 16)
#' normalizedgame(v, binary = TRUE)
#' w <- c(4, 3, 8, 16, 17, 18, 15)
#' normalizedgame(w)
#' z <- c(2,3,5,10,12,14,5)
#' normalizedgame(z)
#' @seealso \link{strategicallyequivalentcheck}, \link{zeronormalizedcheck}, \link{zeronormalizedgame}
#' @export
normalizedgame <- function(v, binary = FALSE) {
  nC <- length(v)
  n <- log(nC + 1)/log(2)
  if (n > floor(n)) {
    stop("'v' must have length 2^n-1 for some n.")
  }
  if (binary == FALSE) {
    ###v <- lex2bin(v) ELIMINEI ESTA SENTENZA
    v0end<- v[nC]-sum(v[1:n]) #NOVA
    v0 <- c(rep(0,nC-1), v0end) #NOVA
    for (jj in (n+1):(nC-1)){ #BUCLE PEQUENO: SÓ NOS QUE SEI QUE PODEN CAMBIAR
      P <-getcoalition(codelex2bin(n,jj)) #NOVA: OS XOGADORES INDIVIDUAIS ESTÁN NESTA POSICIÓN P
      v0[jj]<-v[jj]-sum(v[P]) #NOVA: CONTA FINAL PARA CALCULAR O V0 DA COALICIÓN jj
    }
  }
  else{ # A PARTIR DAQUÍ XA É COMA ANTES: CASO V EN BINARIA
    v0 <- v
    for (jj in 1:nC) {
      num <- jj
      J <- floor(log2(num)) + 1
      P <- c()
      for (ii in 1:J) {
        if (num%%2 == 1) {
          P <- c(P, ii)
        }
        num <- num%/%2
      }
      v0[jj] <- v[jj] - sum(v[2^(P - 1)])
    }
  }
  #CÁLCULO DE V1 (TODO IGUAL CA ANTES)
  if (v0[nC] > 0) {
    v1 <- v0
    k <- 1/v0[nC]
    v1 <- k * v0
  }
  else if (v0[nC] < 0) {
    v1 <- v0
    k <- -1/v0[nC]
    v1 <- k * v0
  }
  else {
    v1 <- v0
  }

  return(v1)
} # Fin de la función
