graphgame <- function(v, G) {
  # GRAPHGAME Graph-restricted game
  # v <- c(0, 1, 1, 2, 1, 2, 2)
  # G <- matrix(c(1, 2, 2, 3, 4, 5), ncol = 2, byrow = TRUE)
  # Example (representación grafo)
  # if(!require('igraph')) {
  # install.packages('igraph')
  # library('igraph')
  #}
  #   g <- graph(edges = as.vector(t(G)), directed = FALSE)
  # plot(g, main = "Communication graph")
  # G <- matrix(c(
  #+     1, 2,  # Nodo 1 conectado con Nodo 2
  #+     1, 3,  # Nodo 1 conectado con Nodo 3
  #+     2, 3,  # Nodo 2 conectado con Nodo 3
  #+     3, 4,  # Nodo 3 conectado con Nodo 4
  #+     4, 5,  # Nodo 4 conectado con Nodo 5
  #+     6, 7,  # Nodo 6 conectado con Nodo 7
  #+     7, 8,  # Nodo 7 conectado con Nodo 8
  #+     8, 9,  # Nodo 8 conectado con Nodo 9
  #+     9, 6,  # Nodo 9 conectado con Nodo 6
  #+     10, 7  # Nodo 10 conectado con Nodo 7
  #+ ), byrow = TRUE, ncol = 2)
  # g <- graph(edges= c(1,2,1,3,2,3,3,4,4,5,6,7,7,8,8,9,9,6,10,7), directed=FALSE)

  # Número de arcos
  m <- nrow(G)

  # Número de jugadores
  n <- log2(length(v) + 1)

  # Vector para almacenar los valores del juego restringido
  vG <- numeric(2^n - 1)

  # Recorremos todas las coaliciones
  for (S in 1:(2^n - 1)) {
    if (S %in% 2^(0:(n-1))) {
      # Si S es un singleton
      vG[S] <- v[S]  # vG({i}) = v({i})
    } else {
      # Si S no es una coalición unitaria

      # Primero calculamos el grafo restringido
      # Nodos = Jugadores
      Splayers <- integer(0)
      SS <- S
      # Jugador más grande en la coalición S
      J <- floor(log2(SS)) + 1

      # Algoritmo de las divisiones entre dos para convertir un número entero a binario
      for (ii in 1:J) {
        if (SS %% 2 == 1) {
          Splayers <- c(Splayers, ii)
        }
        SS <- floor(SS / 2)
      }

      # Arcos uniendo jugadores en S
      mrest <- 0
      Grest <- matrix(0, nrow = 0, ncol = 2)

      for (ii in 1:m) {# recorremos la matriz de arcos por filas
        if (all(G[ii, ] %in% Splayers)) {
          # Si todos los elementos del arco G[ii, ] son jugadores de S, entonces este arco forma parte del grafo restringido
          mrest <- mrest + 1
          Grest <- rbind(Grest, G[ii, ])
        }
      }

      # Componentes conexas del grafo restringido a S
      CS <- graphcomponents(Splayers, Grest)

      # Calculamos el valor de vG(S) como la suma de los valores de v en las componentes conexas
      vG[S] <- 0
      for (t in seq_along(CS)) {
        # Número binario de cada componente conexa
        binary_sum <- sum(2^(CS[[t]] - 1))
        vG[S] <- vG[S] + v[binary_sum]
      } # Fin del control si S es o no unitaria
    } # Fin del bucle en la coalicion S
  }

  return(vG)
}
