% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trend_estimate.R
\name{trend_estimate}
\alias{trend_estimate}
\title{Trend estimation with controlled smoothing.}
\usage{
trend_estimate(dat, smoothing_level = NULL, lambda = NULL,
  plot = TRUE, label = time(dat), jump = NULL, las = 2,
  bands = TRUE)
}
\arguments{
\item{dat}{is a 2x2 matrix with the two time series. Each column correspond to the values at a given time.}

\item{smoothing_level}{is a scalar between 0 and 1 that specifies the smoothing of the resulting time series tau.}

\item{lambda}{Alternative, the function directly accepts the lambda value that corresponds to the desired smoothing level.}

\item{plot}{is TRUE when we cant to plot of the original agaist the resulting series.}

\item{label}{vector of characters that corresponds to the labels for each time point in the serie.}

\item{jump}{is a vector of integers that specifies which values of labels should appear in the x labels.}

\item{las}{is 1(2) if the x labels should be vertical (horizontal).}

\item{bands}{is TRUE tolo include 95\% confidence bands in the plots.}
}
\value{
The smoothed series tau.

The orginal data dat.

The estimation for sigma_eta, sigma.eta

The length of the time series N.

The lambda value corresponding to the smoothing level.

The diagonal values of the estimated variance of tau, diag.var.tau

A flag that indicates if data is a bivariate time series.
}
\description{
This is the main function that estimates the trend for univariate or bivariate time series for a specified
smoothing level.
}
\examples{

# Employment in agriculture (\\\% of total employment) (modeled ILO estimate) in OCDE members
data(emp_agr) #It is a ts object with one single time series
sts<-trend_estimate(emp_agr,0.70)
plot_trend(sts, title="Employment in agriculture in OCDE members", xlab = "Years")

# Data Trade (\\\% of GDP) for USA and Mexico downloaded from
data(trade) #It is a numeric matrix with two columns
sts<-trend_estimate(trade,0.7)
plot_trend(sts, title="Trade in\% of GDP",xlab="years")

ts_trade<-ts(trade, start=1969,end=2017) #We transform tade to a ts object
sts<-trend_estimate(ts_trade,0.7)
plot_trend(sts, title="Trade in\% of GDP",xlab="years")


}
