% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RESTREND.R
\name{RESTREND}
\alias{RESTREND}
\title{RESTREND (RESidual TREND)}
\usage{
RESTREND(
  anu.VI,
  acu.RF,
  VI.index,
  acu.TM = NULL,
  sig = 0.05,
  retnonsig = FALSE
)
}
\arguments{
\item{anu.VI}{The annual (Growing season) max VI. Must be a object of class \code{'ts'} without NA's.
if anu.VI=FALSE, it will be calculated from the CTSR.VI using \code{\link{AnMaxVI}}.}

\item{acu.RF}{The optimal accumulated rainfall for anu.VI. Must be a object of class \code{'ts'} without
NA's and be of equal length and temporal range to anu.VI. if anu.RF=FALSE, it will be
calculated from ACP.table usingthe \code{\link{AnnualClim.Cal}}}

\item{VI.index}{the index of the CTSR.VI ts that the anu.VI values occur at. Must be the same length
as anu.VI. NOTE. R indexs from 1 rather than 0.
if VI.index=FALSE, it will be calculated from the CTSR.VI using \code{\link{AnMaxVI}}.}

\item{acu.TM}{The optimal accumulated rainfall for anu.TM. Must be a object of class \code{'ts'} without
NA's and be of equal length and temporal range to anu.TM. if anu.TM=FALSE, it will be
calculated from ACT.table usingthe \code{\link{AnnualClim.Cal}}}

\item{sig}{Significance of all the functions. defualt sig=0.05}

\item{retnonsig}{Bool. New in v0.3.0. Allows TSSRESTREND to return change estimates of values that filed the sig component in the residual analysis.
defualt FALSE will give the same result as eralier versions.}
}
\value{
a list of class TSSRESTREND.
       See \code{\link{TSSRESTREND}} for details. Note. if called seperatly from TSSRESTREND,
       this list will be incomplete.
}
\description{
For ts with no significant breakpoints in the residuals or the VPR. Takes annual VI max and it associated optimal accumulated precipitation
}
\examples{
restrend <- RESTREND(stdRESTREND$max.NDVI, stdRESTREND$acc.precip, stdRESTREND$index)
print(restrend)
}
\author{
Arden Burrell, arden.burrell@unsw.edu.au
}
