% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tspred.r
\name{preprocess.tspred}
\alias{preprocess.tspred}
\title{Preprocess method for \code{\link{tspred}} objects}
\usage{
\method{preprocess}{tspred}(obj, prep_test = FALSE, ...)
}
\arguments{
\item{obj}{An object of class \code{\link{tspred}} defining a particular time series prediction process.}

\item{prep_test}{Should the testing set of data be preprocessed as well?}

\item{...}{Other parameters passed to the method \code{\link{preprocess}} of
the \code{\link{processing}} objects from \code{obj}.}
}
\value{
An object of class \code{tspred} with updated structure containing
preprocessed time series data.
}
\description{
Performs preprocessing of the time series data contained in a \code{\link{tspred}} class object
based on a particular set of transformation methods. Each transformation method is defined
by a \code{\link{processing}} object in the list contained in the \code{\link{tspred}} class object.
}
\details{
The function \code{\link{preprocess.tspred}} recursively calls the method \code{\link{preprocess}}
on each \code{\link{processing}} object contained in \code{obj}. The preprocessed time series
resulting from each of these calls is used as input to the next call. Thus, the order of the
list of \code{\link{processing}} objects in \code{obj} becomes important. Finally, the produced
preprocessed time series data are introduced in the structure of the \code{\link{tspred}} class object in \code{obj}.

If any transformation method parameters are computed during preprocessing, they are duly updated
in the structure of the \code{\link{tspred}} class object in \code{obj}. This is important not
only for provenance and reprodutibility of the prediction process, but it is also crucial
for the postprocessing step, since the same parameters must be used for reversing any transformations.
Furthermore, if \code{prep_test} is \code{TRUE}, testing sets are preprocessed
with the same parameters saved from preprocessing the training set.
}
\examples{
data(CATS)

#Obtaining objects of the processing class
proc1 <- subsetting(test_len=20)
proc2 <- BoxCoxT(lambda=NULL)
proc3 <- WT(level=1, filter="bl14")

#Obtaining objects of the modeling class
modl1 <- ARIMA()

#Obtaining objects of the evaluating class
eval1 <- MSE_eval()

#Defining a time series prediction process
tspred_1 <- tspred(subsetting=proc1,
                   processing=list(BCT=proc2,
                                   WT=proc3),
                   modeling=modl1,
                   evaluating=list(MSE=eval1)
)
summary(tspred_1)

tspred_1 <- subset(tspred_1, data=CATS[3])
tspred_1 <- preprocess(tspred_1,prep_test=FALSE)

}
\seealso{
[tspred()] for defining a particular time series prediction process,
and [LT()] for defining a time series transformation method.

Other preprocess: 
\code{\link{postprocess.tspred}()},
\code{\link{subset}()}
}
\author{
Rebecca Pontes Salles
}
\concept{preprocess}
\keyword{postprocessing}
\keyword{preprocessing}
\keyword{processing}
\keyword{transformation}
