% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeling.r
\name{modeling}
\alias{modeling}
\alias{linear}
\alias{MLM}
\title{Time series modeling and prediction}
\usage{
modeling(
  train_func,
  train_par = NULL,
  pred_func = NULL,
  pred_par = NULL,
  ...,
  subclass = NULL
)

MLM(
  train_func,
  train_par = NULL,
  pred_func = NULL,
  pred_par = NULL,
  sw = NULL,
  proc = NULL,
  ...,
  subclass = NULL
)

linear(
  train_func,
  train_par = NULL,
  pred_func = NULL,
  pred_par = NULL,
  ...,
  subclass = NULL
)
}
\arguments{
\item{train_func}{A function for training a particular model.}

\item{train_par}{List of named parameters required by \code{train_func}.}

\item{pred_func}{A function for prediction based on the model trained by \code{train_func}.}

\item{pred_par}{List of named parameters required by \code{pred_func}.}

\item{...}{Other parameters to be encapsulated in the class object.}

\item{subclass}{Name of new specialized subclass object created in case it is provided.}

\item{sw}{A \code{\link{SW}} object regarding sliding windows processing. Optional.}

\item{proc}{A list of \code{\link{processing}} objects regarding any pre(post)processing
needed during training or prediction. Optional.}
}
\value{
An object of class \code{modeling}.
}
\description{
Constructor for the \code{modeling} class representing a time series modeling
and prediction method based on a particular model.
The \code{modeling} class has two specialized subclasses \code{linear} and
\code{MLM} reagarding linear models and machine learning based models, respectively.
}
\examples{

forecast_mean <- function(...){
   do.call(forecast::forecast,c(list(...)))$mean
}

l <- linear(train_func = forecast::auto.arima, pred_func = forecast_mean,
            method="ARIMA model", subclass="ARIMA")
summary(l)

m <- MLM(train_func = nnet::nnet, train_par=list(size=5),
      pred_func = predict, sw=SW(window_len = 6), proc=list(MM=MinMax()),
      method="Artificial Neural Network model", subclass="NNET")
summary(m)

}
\seealso{
Other constructors: 
\code{\link{ARIMA}()},
\code{\link{LT}()},
\code{\link{MSE_eval}()},
\code{\link{evaluating}()},
\code{\link{processing}()},
\code{\link{tspred}()}
}
\author{
Rebecca Pontes Salles
}
\concept{constructors}
\keyword{method}
\keyword{model}
\keyword{modeling}
\keyword{prediction}
