#' Continuation dataset of the Dataset A of the NN3 Competition 
#' 
#' A dataset of univariate time series providing 18 points beyond the end of
#' the time series in \code{\link{NN3.A}}. 
#' 
#' Contains the 18 observations which were to be predicted of each time series
#' in Dataset A (\code{\link{NN3.A}}) as demanded by the NN3 Competition. 
#' 
#' @name NN3.A.cont
#' @docType data
#' @format A data frame with 18 observations on the following 111 variables.
#' \describe{ \item{NN3.001}{a numeric vector containing further
#' observations of \code{NN3.001} in \code{\link{NN3.A}}.}
#' \item{NN3.002}{a numeric vector containing further observations of
#' \code{NN3.002} in \code{\link{NN3.A}}.} \item{NN3.003}{a numeric
#' vector containing further observations of \code{NN3.003} in
#' \code{\link{NN3.A}}.} \item{NN3.004}{a numeric vector containing
#' further observations of \code{NN3.004} in \code{\link{NN3.A}}.}
#' \item{NN3.005}{a numeric vector containing further observations of
#' \code{NN3.005} in \code{\link{NN3.A}}.} \item{NN3.006}{a numeric
#' vector containing further observations of \code{NN3.006} in
#' \code{\link{NN3.A}}.} \item{NN3.007}{a numeric vector containing
#' further observations of \code{NN3.007} in \code{\link{NN3.A}}.}
#' \item{NN3.008}{a numeric vector containing further observations of
#' \code{NN3.008} in \code{\link{NN3.A}}.} \item{NN3.009}{a numeric
#' vector containing further observations of \code{NN3.009} in
#' \code{\link{NN3.A}}.} \item{NN3.010}{a numeric vector containing
#' further observations of \code{NN3.010} in \code{\link{NN3.A}}.}
#' \item{NN3.011}{a numeric vector containing further observations of
#' \code{NN3.011} in \code{\link{NN3.A}}.} \item{NN3.012}{a numeric
#' vector containing further observations of \code{NN3.012} in
#' \code{\link{NN3.A}}.} \item{NN3.013}{a numeric vector containing
#' further observations of \code{NN3.013} in \code{\link{NN3.A}}.}
#' \item{NN3.014}{a numeric vector containing further observations of
#' \code{NN3.014} in \code{\link{NN3.A}}.} \item{NN3.015}{a numeric
#' vector containing further observations of \code{NN3.015} in
#' \code{\link{NN3.A}}.} \item{NN3.016}{a numeric vector containing
#' further observations of \code{NN3.016} in \code{\link{NN3.A}}.}
#' \item{NN3.017}{a numeric vector containing further observations of
#' \code{NN3.017} in \code{\link{NN3.A}}.} \item{NN3.018}{a numeric
#' vector containing further observations of \code{NN3.018} in
#' \code{\link{NN3.A}}.} \item{NN3.019}{a numeric vector containing
#' further observations of \code{NN3.019} in \code{\link{NN3.A}}.}
#' \item{NN3.020}{a numeric vector containing further observations of
#' \code{NN3.020} in \code{\link{NN3.A}}.} \item{NN3.021}{a numeric
#' vector containing further observations of \code{NN3.021} in
#' \code{\link{NN3.A}}.} \item{NN3.022}{a numeric vector containing
#' further observations of \code{NN3.022} in \code{\link{NN3.A}}.}
#' \item{NN3.023}{a numeric vector containing further observations of
#' \code{NN3.023} in \code{\link{NN3.A}}.} \item{NN3.024}{a numeric
#' vector containing further observations of \code{NN3.024} in
#' \code{\link{NN3.A}}.} \item{NN3.025}{a numeric vector containing
#' further observations of \code{NN3.025} in \code{\link{NN3.A}}.}
#' \item{NN3.026}{a numeric vector containing further observations of
#' \code{NN3.026} in \code{\link{NN3.A}}.} \item{NN3.027}{a numeric
#' vector containing further observations of \code{NN3.027} in
#' \code{\link{NN3.A}}.} \item{NN3.028}{a numeric vector containing
#' further observations of \code{NN3.028} in \code{\link{NN3.A}}.}
#' \item{NN3.029}{a numeric vector containing further observations of
#' \code{NN3.029} in \code{\link{NN3.A}}.} \item{NN3.030}{a numeric
#' vector containing further observations of \code{NN3.030} in
#' \code{\link{NN3.A}}.} \item{NN3.031}{a numeric vector containing
#' further observations of \code{NN3.031} in \code{\link{NN3.A}}.}
#' \item{NN3.032}{a numeric vector containing further observations of
#' \code{NN3.032} in \code{\link{NN3.A}}.} \item{NN3.033}{a numeric
#' vector containing further observations of \code{NN3.033} in
#' \code{\link{NN3.A}}.} \item{NN3.034}{a numeric vector containing
#' further observations of \code{NN3.034} in \code{\link{NN3.A}}.}
#' \item{NN3.035}{a numeric vector containing further observations of
#' \code{NN3.035} in \code{\link{NN3.A}}.} \item{NN3.036}{a numeric
#' vector containing further observations of \code{NN3.036} in
#' \code{\link{NN3.A}}.} \item{NN3.037}{a numeric vector containing
#' further observations of \code{NN3.037} in \code{\link{NN3.A}}.}
#' \item{NN3.038}{a numeric vector containing further observations of
#' \code{NN3.038} in \code{\link{NN3.A}}.} \item{NN3.039}{a numeric
#' vector containing further observations of \code{NN3.039} in
#' \code{\link{NN3.A}}.} \item{NN3.040}{a numeric vector containing
#' further observations of \code{NN3.040} in \code{\link{NN3.A}}.}
#' \item{NN3.041}{a numeric vector containing further observations of
#' \code{NN3.041} in \code{\link{NN3.A}}.} \item{NN3.042}{a numeric
#' vector containing further observations of \code{NN3.042} in
#' \code{\link{NN3.A}}.} \item{NN3.043}{a numeric vector containing
#' further observations of \code{NN3.043} in \code{\link{NN3.A}}.}
#' \item{NN3.044}{a numeric vector containing further observations of
#' \code{NN3.044} in \code{\link{NN3.A}}.} \item{NN3.045}{a numeric
#' vector containing further observations of \code{NN3.045} in
#' \code{\link{NN3.A}}.} \item{NN3.046}{a numeric vector containing
#' further observations of \code{NN3.046} in \code{\link{NN3.A}}.}
#' \item{NN3.047}{a numeric vector containing further observations of
#' \code{NN3.047} in \code{\link{NN3.A}}.} \item{NN3.048}{a numeric
#' vector containing further observations of \code{NN3.048} in
#' \code{\link{NN3.A}}.} \item{NN3.049}{a numeric vector containing
#' further observations of \code{NN3.049} in \code{\link{NN3.A}}.}
#' \item{NN3.050}{a numeric vector containing further observations of
#' \code{NN3.050} in \code{\link{NN3.A}}.} \item{NN3.051}{a numeric
#' vector containing further observations of \code{NN3.051} in
#' \code{\link{NN3.A}}.} \item{NN3.052}{a numeric vector containing
#' further observations of \code{NN3.052} in \code{\link{NN3.A}}.}
#' \item{NN3.053}{a numeric vector containing further observations of
#' \code{NN3.053} in \code{\link{NN3.A}}.} \item{NN3.054}{a numeric
#' vector containing further observations of \code{NN3.054} in
#' \code{\link{NN3.A}}.} \item{NN3.055}{a numeric vector containing
#' further observations of \code{NN3.055} in \code{\link{NN3.A}}.}
#' \item{NN3.056}{a numeric vector containing further observations of
#' \code{NN3.056} in \code{\link{NN3.A}}.} \item{NN3.057}{a numeric
#' vector containing further observations of \code{NN3.057} in
#' \code{\link{NN3.A}}.} \item{NN3.058}{a numeric vector containing
#' further observations of \code{NN3.058} in \code{\link{NN3.A}}.}
#' \item{NN3.059}{a numeric vector containing further observations of
#' \code{NN3.059} in \code{\link{NN3.A}}.} \item{NN3.060}{a numeric
#' vector containing further observations of \code{NN3.060} in
#' \code{\link{NN3.A}}.} \item{NN3.061}{a numeric vector containing
#' further observations of \code{NN3.061} in \code{\link{NN3.A}}.}
#' \item{NN3.062}{a numeric vector containing further observations of
#' \code{NN3.062} in \code{\link{NN3.A}}.} \item{NN3.063}{a numeric
#' vector containing further observations of \code{NN3.063} in
#' \code{\link{NN3.A}}.} \item{NN3.064}{a numeric vector containing
#' further observations of \code{NN3.064} in \code{\link{NN3.A}}.}
#' \item{NN3.065}{a numeric vector containing further observations of
#' \code{NN3.065} in \code{\link{NN3.A}}.} \item{NN3.066}{a numeric
#' vector containing further observations of \code{NN3.066} in
#' \code{\link{NN3.A}}.} \item{NN3.067}{a numeric vector containing
#' further observations of \code{NN3.067} in \code{\link{NN3.A}}.}
#' \item{NN3.068}{a numeric vector containing further observations of
#' \code{NN3.068} in \code{\link{NN3.A}}.} \item{NN3.069}{a numeric
#' vector containing further observations of \code{NN3.069} in
#' \code{\link{NN3.A}}.} \item{NN3.070}{a numeric vector containing
#' further observations of \code{NN3.070} in \code{\link{NN3.A}}.}
#' \item{NN3.071}{a numeric vector containing further observations of
#' \code{NN3.071} in \code{\link{NN3.A}}.} \item{NN3.072}{a numeric
#' vector containing further observations of \code{NN3.072} in
#' \code{\link{NN3.A}}.} \item{NN3.073}{a numeric vector containing
#' further observations of \code{NN3.073} in \code{\link{NN3.A}}.}
#' \item{NN3.074}{a numeric vector containing further observations of
#' \code{NN3.074} in \code{\link{NN3.A}}.} \item{NN3.075}{a numeric
#' vector containing further observations of \code{NN3.075} in
#' \code{\link{NN3.A}}.} \item{NN3.076}{a numeric vector containing
#' further observations of \code{NN3.076} in \code{\link{NN3.A}}.}
#' \item{NN3.077}{a numeric vector containing further observations of
#' \code{NN3.077} in \code{\link{NN3.A}}.} \item{NN3.078}{a numeric
#' vector containing further observations of \code{NN3.078} in
#' \code{\link{NN3.A}}.} \item{NN3.079}{a numeric vector containing
#' further observations of \code{NN3.079} in \code{\link{NN3.A}}.}
#' \item{NN3.080}{a numeric vector containing further observations of
#' \code{NN3.080} in \code{\link{NN3.A}}.} \item{NN3.081}{a numeric
#' vector containing further observations of \code{NN3.081} in
#' \code{\link{NN3.A}}.} \item{NN3.082}{a numeric vector containing
#' further observations of \code{NN3.082} in \code{\link{NN3.A}}.}
#' \item{NN3.083}{a numeric vector containing further observations of
#' \code{NN3.083} in \code{\link{NN3.A}}.} \item{NN3.084}{a numeric
#' vector containing further observations of \code{NN3.084} in
#' \code{\link{NN3.A}}.} \item{NN3.085}{a numeric vector containing
#' further observations of \code{NN3.085} in \code{\link{NN3.A}}.}
#' \item{NN3.086}{a numeric vector containing further observations of
#' \code{NN3.086} in \code{\link{NN3.A}}.} \item{NN3.087}{a numeric
#' vector containing further observations of \code{NN3.087} in
#' \code{\link{NN3.A}}.} \item{NN3.088}{a numeric vector containing
#' further observations of \code{NN3.088} in \code{\link{NN3.A}}.}
#' \item{NN3.089}{a numeric vector containing further observations of
#' \code{NN3.089} in \code{\link{NN3.A}}.} \item{NN3.090}{a numeric
#' vector containing further observations of \code{NN3.090} in
#' \code{\link{NN3.A}}.} \item{NN3.091}{a numeric vector containing
#' further observations of \code{NN3.091} in \code{\link{NN3.A}}.}
#' \item{NN3.092}{a numeric vector containing further observations of
#' \code{NN3.092} in \code{\link{NN3.A}}.} \item{NN3.093}{a numeric
#' vector containing further observations of \code{NN3.093} in
#' \code{\link{NN3.A}}.} \item{NN3.094}{a numeric vector containing
#' further observations of \code{NN3.094} in \code{\link{NN3.A}}.}
#' \item{NN3.095}{a numeric vector containing further observations of
#' \code{NN3.095} in \code{\link{NN3.A}}.} \item{NN3.096}{a numeric
#' vector containing further observations of \code{NN3.096} in
#' \code{\link{NN3.A}}.} \item{NN3.097}{a numeric vector containing
#' further observations of \code{NN3.097} in \code{\link{NN3.A}}.}
#' \item{NN3.098}{a numeric vector containing further observations of
#' \code{NN3.098} in \code{\link{NN3.A}}.} \item{NN3.099}{a numeric
#' vector containing further observations of \code{NN3.099} in
#' \code{\link{NN3.A}}.} \item{NN3.100}{a numeric vector containing
#' further observations of \code{NN3.100} in \code{\link{NN3.A}}.}
#' \item{NN3_101}{a numeric vector containing further observations of
#' \code{NN3_101} in \code{\link{NN3.A}}.} \item{NN3_102}{a numeric
#' vector containing further observations of \code{NN3_102} in
#' \code{\link{NN3.A}}.} \item{NN3_103}{a numeric vector containing
#' further observations of \code{NN3_103} in \code{\link{NN3.A}}.}
#' \item{NN3_104}{a numeric vector containing further observations of
#' \code{NN3_104} in \code{\link{NN3.A}}.} \item{NN3_105}{a numeric
#' vector containing further observations of \code{NN3_105} in
#' \code{\link{NN3.A}}.} \item{NN3_106}{a numeric vector containing
#' further observations of \code{NN3_106} in \code{\link{NN3.A}}.}
#' \item{NN3_107}{a numeric vector containing further observations of
#' \code{NN3_107} in \code{\link{NN3.A}}.} \item{NN3_108}{a numeric
#' vector containing further observations of \code{NN3_108} in
#' \code{\link{NN3.A}}.} \item{NN3_109}{a numeric vector containing
#' further observations of \code{NN3_109} in \code{\link{NN3.A}}.}
#' \item{NN3_110}{a numeric vector containing further observations of
#' \code{NN3_110} in \code{\link{NN3.A}}.} \item{NN3_111}{a numeric
#' vector containing further observations of \code{NN3_111} in
#' \code{\link{NN3.A}}.} }
#' @seealso \code{\link{NN3.A}} ~
#' @references S.F. Crone, M. Hibon, and K. Nikolopoulos, 2011, Advances in
#' forecasting with neural networks? Empirical evidence from the NN3
#' competition on time series prediction, International Journal of Forecasting,
#' v. 27, n. 3 (Jul.), p. 635-660. 
#' @source NN3 2007, The NN3 Competition: Forecasting competition for
#' artificial neural networks and computational intelligence. URL:
#' \url{http://www.neural-forecasting-competition.com/NN3/index.htm}. 
#' @keywords datasets NN3 Time Series Competition
#' @examples
#' 
#' data(NN3.A.cont)
#' str(NN3.A.cont)
#' plot(ts(NN3.A.cont["NN3_111"]))
#' 
"NN3.A.cont"
#> [1] "NN3.A.cont"