% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TSE.R
\name{AVERSE}
\alias{AVERSE}
\title{Calculate average relative squared error (aRSE)}
\usage{
AVERSE(Actuals1 = data.frame(), Observed1 = data.frame(), ...)
}
\arguments{
\item{Actuals1}{= data from a "gold standard" survey; objects are variable columns
from "gold standard" survey that corruspond to variable columns Observed1}

\item{Observed1}{= data from survey 1; objects are variable columns from
survey 1 that corruspond to variable columns from Actuals1}

\item{...}{= "gold standard" data/survey # data for additional surveys}
}
\value{
Average relative squared error (aRSE)
}
\description{
Calculates average relative squared error (aRSE) for one
or more surveys
}
\details{
aRSE for survey # => mean value of the RSEs for specified variables in
survey # => mean value of RSEs for objects in Observed#=data.frame()
}
\note{
Make sure to properly order inputs, per the example: Actuals1=data.frame()
objects and corrusponding Observed1=data.frame() objects must be given in the
same order as each other; and ... must be given in numbered pairs of Actuals#,
Observed#, and those pairs given in sequence of their #s.
}
\examples{
AVERSE(Actuals1=data.frame(TESTNUMB$AQ1, TESTNUMB$AQ2),
Observed1=data.frame(TESTNUMB$O1Q1, TESTNUMB$O1Q2),
Actuals2=data.frame(TESTNUMB$AQ1, TESTNUMB$AQ2),
Observed2=data.frame(TESTNUMB$O2Q1, TESTNUMB$O2Q2),
Actuals3=data.frame(TESTNUMB$AQ1, TESTNUMB$AQ2),
Observed3=data.frame(TESTNUMB$O3Q1, TESTNUMB$O3Q2))
}
