% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TSDT_scoring_functions.R
\name{mean_deviance_residuals}
\alias{mean_deviance_residuals}
\title{mean_deviance_residuals}
\usage{
mean_deviance_residuals(data, scoring_function_parameters = NULL)
}
\arguments{
\item{data}{data.frame containing response data}

\item{scoring_function_parameters}{named list of scoring function control parameters}
}
\value{
Mean of deviance residuals
}
\description{
Computes the mean of the deviance residuals from a survival model
}
\details{
Computes the mean of the deviance residuals from a survival model.
The deviance residual at time t is computed as the observed number of events
at time t minus the expected number of events at time t (see Therneau, et. al.
linked below). The expected number of events is the number of events predicted
by the survival model. If the event under study is an undesirable event (as
would likely be the case in a clinical context), then a smaller value for the
deviance residual is desirable -- i.e. it is desirable to observe fewer events
than expected from the survival model. In this case the appropriate value for
desirable_response in TSDT is desirable_response = 'decreasing'. If the event
under study is desirable then the appropriate value for desirable_response is
desirable_response = 'increasing'. It is assumed that most survival models are
modeling an undesirable event. Therefore, when the user specifies
mean_deviance_residual or diff_mean_deviance_residual, the default value for
desirable_repsonse is changed to 'decreasing', unless the user explicitly
provides desirable_response = 'increasing'. Note this differs from all other
TSDT configurations, for which the default value for desirable_response is
desirable_response = 'increasing'.
}
\references{
Therneau, T.M.,  Grambsch, P.M., and Fleming, T.R. (1990).  Martingale-based
residuals for survival models.  Biometrika, 77(1), 147-160.
\doi{10.1093/biomet/77.1.147}
}
\seealso{
\link{TSDT}, \link[survival]{Surv}, \link[survival]{coxph},
\link[survival]{survfit}
}
