% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lm_dummy.R
\name{lm_dummy}
\alias{lm_dummy}
\title{Perform one random experiment}
\usage{
lm_dummy(
  X,
  y,
  model_tlars,
  T_stop = 1,
  num_dummies = ncol(X),
  method = "trex",
  GVS_type = "IEN",
  type = "lar",
  corr_max = 0.5,
  lambda_2_lars = NULL,
  early_stop = TRUE,
  verbose = TRUE,
  intercept = FALSE,
  standardize = TRUE
)
}
\arguments{
\item{X}{Real valued predictor matrix.}

\item{y}{Response vector.}

\item{model_tlars}{Object of the class tlars_cpp. It contains all state variables of the previous T-LARS step (necessary for warm-starts, i.e., restarting
the forward selection process exactly where it was previously terminated).}

\item{T_stop}{Number of included dummies after which the random experiments (i.e., forward selection processes) are stopped.}

\item{num_dummies}{Number of dummies that are appended to the predictor matrix.}

\item{method}{'trex' for the T-Rex selector (\doi{10.48550/arXiv.2110.06048}),
'trex+GVS' for the T-Rex+GVS selector (\doi{10.23919/EUSIPCO55093.2022.9909883}),
'trex+DA+AR1' for the T-Rex+DA+AR1 selector,
'trex+DA+equi' for the T-Rex+DA+equi selector,
'trex+DA+BT' for the T-Rex+DA+BT selector (\doi{10.48550/arXiv.2401.15796}),
'trex+DA+NN' for the T-Rex+DA+NN selector (\doi{10.48550/arXiv.2401.15139}).}

\item{GVS_type}{'IEN' for the Informed Elastic Net (\doi{10.1109/CAMSAP58249.2023.10403489}),
'EN' for the ordinary Elastic Net (\doi{10.1111/j.1467-9868.2005.00503.x}).}

\item{type}{'lar' for 'LARS' and 'lasso' for Lasso.}

\item{corr_max}{Maximum allowed correlation between any two predictors from different clusters.}

\item{lambda_2_lars}{lambda_2-value for LARS-based Elastic Net.}

\item{early_stop}{Logical. If TRUE, then the forward selection process is stopped after T_stop dummies have been included. Otherwise
the entire solution path is computed.}

\item{verbose}{Logical. If TRUE progress in computations is shown when performing T-LARS steps on the created model.}

\item{intercept}{Logical. If TRUE an intercept is included.}

\item{standardize}{Logical. If TRUE the predictors are standardized and the response is centered.}
}
\value{
Object of the class tlars_cpp.
}
\description{
Run one random experiment of the T-Rex selector (\doi{10.48550/arXiv.2110.06048}), i.e., generates dummies, appends them to the predictor matrix, and runs
the forward selection algorithm until it is terminated after T_stop dummies have been selected.
}
\examples{
set.seed(123)
eps <- .Machine$double.eps
n <- 75
p <- 100
X <- matrix(stats::rnorm(n * p), nrow = n, ncol = p)
beta <- c(rep(3, times = 3), rep(0, times = 97))
y <- X \%*\% beta + rnorm(n)
res <- lm_dummy(X = X, y = y, T_stop = 1, num_dummies = 5 * p)
beta_hat <- res$get_beta()[seq(p)]
support <- abs(beta_hat) > eps
support
}
