% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TPDsMean.R
\name{TPDsMean}
\alias{TPDsMean}
\title{Creating TPDs without individual observations}
\usage{
TPDsMean(species, means, sds, covar = FALSE, alpha = 0.95,
  samples = NULL, trait_ranges = NULL, n_divisions = NULL,
  tolerance = 0.05)
}
\arguments{
\item{species}{A vector containing the names of the species whose TPD is to be calculated.
The length of 'species' must match the number of rows of 'traits', and the length of 'sigmas'.
NA values are not allowed.}

\item{means}{A matrix or data.frame containing the average trait values of each  species (or population).
Species are in rows and  traits in columns, with one column for each trait. NA values are not allowed.}

\item{sds}{A matrix or data.frame containing the standard deviation of trait values of each  species
(or population). Species are in rows and  traits in columns, with one column for each trait. NA values are not allowed.}

\item{covar}{Logical; if TRUE, the covariance between traits is calculated using the mean trait values and
considered in the construction of the multivariate normal distributions. Defaults to FALSE.}

\item{alpha}{A number between 0 and 1, indicating the proportion of the probability density function of
each population to include. A value of 1 includes the whole density function, but may be sensitive
to the presence of outliers. Defaults to 0.95.}

\item{samples}{A vector containing the identity of the sampling unit in which each individual was present.
Defaults to NULL, in which case, a TPDs is calculated for each species. If it is not NULL,
a TPDs is calculated for each combination of 'species x sampling unit'  (ie, a TPDs for each population).
NA values are not allowed.}

\item{trait_ranges}{A vector or a list indicating the range of trait values that will be considered in
the calculations. If a vector is provided, each    element should indicate the interval (in number of
standard deviations) by which the range of    each trait should be expanded in each direction.
In that case, an interval of n standard deviations is calculated around each species mean trait
value, and the absolute maximum and minimum across all species are selected as the range for
each trait.If a list is provided, it should contain the range (minimum and maximum) of trait
values that will be considered.Each element of the vector or list corresponds with one trait.
The order of the traits must be the same as the order of the columns in the 'traits' arguments.
Defaults to    NULL, in which case, the ranges of all the traits are automatically calculated by
expanding the range of the columns in 'means' by 5 times the values in 'sds' in each direction.
Trait ranges that are too short may result in an inadequate characterization of TPDs.}

\item{n_divisions}{The number of equal-length parts in which each trait should be divided to calculate
the grid in which calculations are based. Note    the number of cells composing the grid increases
exponentially as    dimensionality increases, which can result in  high computation times. Defaults to NULL,
in which case one trait is divided into 1000 parts, two traits are divided into 200 parts (40,000 cells),
three traits are divided into 50 parts (125,000 cells), and 4 traits are divided into 25 parts
(390,625 cells).}

\item{tolerance}{A number between 0 and 1, giving the admissible proportion of deviation from 1 in the
integral of the TPDs of each population. Integrals can be lower than 1 when the extent of the evaluation
grid is not enough to capture all the probability density function of the species. These problems
are usually solved by increasing 'trait_ranges'. When the absolute deviation is greater than 'tolerance',
a warning message is produced, but the TPDsMean function does not fail. Defaults to 0.05.}
}
\value{
\code{TPDsMean} returns an object of class "TPDsp", which is a list containing the following components:

\emph{data:} A list containing information used to perform the calculations, including the coordinates
  --in trait space-- in which the TPD function has been evaluated, the volume --in trait units--
  of each cell of the grid, the length of each edges of the cells of the grid, the original trait data
  (means and sds matrices), the names of the species, the alpha level specified by the user,
  and the type of TPDs calculated.

 \emph{TPDs:} A list, with one element per species or population, containing the probability associated
 to each cell of the grid in which the trait space has been divided.
}
\description{
\code{TPDsMean} estimates the TPDs of species using the mean trait values and covariance matrix of traits.
 It is most useful when there is no trait information at the individual level, but the mean and
 variance (and optionally covariance) of traits are known.
}
\examples{

# 1.  Compute the TPDs of three different species (1 dimension)
sp_ex <- unique(iris$Species)
mt1 <- tapply(iris[, "Sepal.Length"], iris$Species, mean)
means_ex <- matrix(c(mt1), ncol=1)
st1 <- tapply(iris[, "Sepal.Length"], iris$Species, sd)
sds_ex <- matrix(c(st1), ncol=1)
TPDs_iris<- TPDsMean(species = sp_ex, means = means_ex, sds = sds_ex)

# 2.  Compute the TPDs of three different species (2 dimensions)
sp_ex <- unique(iris$Species)
mt1 <- tapply(iris[, "Sepal.Length"], iris$Species, mean)
mt2 <- tapply(iris[, "Sepal.Width"], iris$Species, mean)
means_ex <- matrix(c(mt1, mt2), ncol=2)
st1 <- tapply(iris[, "Sepal.Length"], iris$Species, sd)
st2 <- tapply(iris[, "Sepal.Width"], iris$Species, sd)
sds_ex <- matrix(c(st1, st2), ncol=2)
TPDs_iris<- TPDsMean(species = sp_ex, means = means_ex, sds = sds_ex)

# 3.  Two different populations of each species
samples_aux <- rep(c(rep(1, 25), rep(2, 25)), 3)
sp_ex <- rep(unique(iris$Species), each=2)
mt1 <- tapply(iris[, "Sepal.Length"], (paste0(iris$Species,samples_aux)), mean)
mt2 <- tapply(iris[, "Sepal.Width"], (paste0(iris$Species,samples_aux)), mean)
means_ex <- matrix(c(mt1, mt2), ncol=2)
st1 <- tapply(iris[, "Sepal.Length"], (paste0(iris$Species,samples_aux)), sd)
st2 <- tapply(iris[, "Sepal.Width"], (paste0(iris$Species,samples_aux)), sd)
sds_ex <- matrix(c(st1, st2), ncol=2)
samples_ex<- rep(c("Comm.1","Comm.2"),3)
TPDs_iris_pop <- TPDsMean (species = sp_ex, means = means_ex, sds = sds_ex,
   samples = samples_ex)

}
