% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TestSet_TMTI.R
\name{TestSet_TMTI}
\alias{TestSet_TMTI}
\title{Test a subset of hypotheses in its closure using the TMTI}
\usage{
TestSet_TMTI(
  pvals,
  subset,
  alpha = 0.05,
  tau = NULL,
  K = NULL,
  EarlyStop = FALSE,
  verbose = FALSE,
  gammaList = NULL,
  mc.cores = 1L,
  chunksize = 4 * mc.cores,
  is.sorted = FALSE,
  ...
)
}
\arguments{
\item{pvals}{Numeric vector of p-values.}

\item{subset}{Numeric vector; the subset to be tested.}

\item{alpha}{Numeric; the level to test at, if stopping early. Defaults
to 0.05.}

\item{tau}{Numeric; the treshold to use if using rTMTI. Set to NULL for TMTI
or rtTMTI. Defaults to NULL.}

\item{K}{Integer; The number of p-values to use if using rtTMTI. Set to NULL
for TMTI or tTMTI. Defaults to NULL.}

\item{EarlyStop}{Logical; set to TRUE to stop as soon as a hypothesis can be
accepted at level alpha. This speeds up the procedure, but now only provides
lower bounds on the p-values for the global test.}

\item{verbose}{Logical; set to TRUE to print progress.}

\item{gammaList}{List of functions. Must be such that the ith element
is the gamma function for sets of size i. Set to NULL to bootstrap the
functions assuming independence. Defaults to NULL.}

\item{mc.cores}{Number of cores to parallelize onto.}

\item{chunksize}{Integer indicating the size of chunks to parallelize. E.g.,
if setting chunksize = mc.cores, each time a parallel computation is set up,
each worker will perform only a single task. If mc.cores > chunksize, some
threads will be inactive.}

\item{is.sorted}{Logical, indicating the p-values are pre-sorted. Defaults
to FALSE.}

\item{...}{Additional arguments.}
}
\value{
The adjusted p-value for the test of the hypothesis that there are
no false hypotheses among the selected subset.
}
\description{
Test a subset of hypotheses in its closure using the TMTI
}
\examples{
## Simulate p-values; 10 from false hypotheses, 10 from true
pvals = sort(c(
  rbeta(10, 1, 20), # Mean value of .1
  runif(10)
))
## Test whether the highest 10 contain any false hypotheses
TestSet_TMTI(pvals, subset = 11:20)
}
