% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terr.R
\name{terr}
\alias{terr}
\title{terr function is used to generate a dataset where the error term follows a T-distribution}
\usage{
terr(n, nr, p, dist_type, ...)
}
\arguments{
\item{n}{is the number of observations}

\item{nr}{is the number of observations with a different error T distribution}

\item{p}{is the dimension of the observation}

\item{dist_type}{is the type where the error term obeys a T-distribution}

\item{...}{is additional arguments for the T-distribution function}
}
\value{
X,Y,e
}
\description{
This terr function generates a dataset with a specified number of observations and predictors, along with a response vector that has an error term following a T-distribution.
}
\examples{
set.seed(12)
data <- terr(n = 1200, nr = 200, p = 5, dist_type = "student_t")
str(data)
}
