% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{ploTLCAR}
\alias{ploTLCAR}
\title{Graphical Plot of the TLCAR Distribution}
\usage{
ploTLCAR(x, alpha, a, b, theta, m, type = "pdf")
}
\arguments{
\item{x}{The range of values to plot the distribution.}

\item{alpha}{Parameter representing the distribution of the Topp-Leone component.}

\item{a}{Parameter representing the scale (a) of the Cauchy component.}

\item{b}{Parameter representing the position (b) of the Cauchy component.}

\item{theta}{Parameter representing the scale of the Rayleigh component.}

\item{m}{Additional parameter.}

\item{type}{The type of plot to generate: "pdf" for PDF plot, "cdf" for CDF plot.}
}
\value{
A graphical plot of the TLCAR distribution.
}
\description{
Generate a graphical plot of the probability density function (PDF) or cumulative distribution function (CDF) for the TLCAR distribution.
}
\examples{
ploTLCAR(x = seq(0, 10, by = 0.1), alpha = 0.5, a = 1, b = 0, theta = 2, m = 1, type = "pdf")

}
