% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chMDB.R, R/fileMDB.R, R/generics.R,
%   R/memoMDB.R, R/metaMDB.R
\name{as_fileMDB.chMDB}
\alias{as_fileMDB.chMDB}
\alias{as_fileMDB.fileMDB}
\alias{as_fileMDB}
\alias{as_fileMDB.memoMDB}
\alias{as_fileMDB.metaMDB}
\title{Write an MDB object}
\usage{
\method{as_fileMDB}{chMDB}(
  x,
  path,
  readParameters = list(delim = "\\t", na = "<NA>"),
  htmlModel = TRUE,
  compress = TRUE,
  by = 10^5,
  ...
)

\method{as_fileMDB}{fileMDB}(
  x,
  path,
  readParameters = list(delim = "\\t", na = "<NA>"),
  htmlModel = TRUE,
  compress = TRUE,
  by = 10^5,
  ...
)

as_fileMDB(
  x,
  path,
  readParameters = list(delim = "\\t", na = "<NA>"),
  htmlModel = TRUE,
  compress = TRUE,
  by = 10^5,
  ...
)

\method{as_fileMDB}{memoMDB}(
  x,
  path,
  readParameters = list(delim = "\\t", na = "<NA>"),
  htmlModel = TRUE,
  compress = TRUE,
  by = 10^5,
  ...
)

\method{as_fileMDB}{metaMDB}(
  x,
  path,
  readParameters = list(delim = "\\t", na = "<NA>"),
  htmlModel = TRUE,
  compress = TRUE,
  by = 10^5,
  ...
)
}
\arguments{
\item{x}{an MDB object}

\item{path}{the path where the MDB should be written}

\item{readParameters}{The following parameters are currently supported:
\itemize{
\item \strong{delim}: a single character used to separate fields within a record
(default: '\\t')
\item \strong{quoted_na}: a single logical indicating if missing values inside quotes
should be treated as missing values or strings.
WARNING: THIS PARAMETER IS NOT TAKEN INTO ACCOUNT WITH readr>=2.0.0.
\item \strong{na}: String used for missing values. The default value for reading
a fileMDB is "NA". But the default value for writing a fileMDB
is ""<NA>"".
This value is written in the DESCRIPTION.json file to avoid ambiguity
when reading the fileMDB.
}}

\item{htmlModel}{a logical. If TRUE (default) the model is also plotted in
an html file.}

\item{compress}{a logical specifying whether saving data
is to use "gzip" compression (default: TRUE)}

\item{by}{the size of the batch: number of records to write
together (default: 10^5)}

\item{...}{method specific parameters}
}
\value{
A \link{fileMDB} object.
}
\description{
Write an MDB object
}
