% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CV.TGST.R
\name{CV.TGST}
\alias{CV.TGST}
\title{Cross Validation}
\usage{
CV.TGST(Obj, lambda, K = 10)
}
\arguments{
\item{Obj}{An object of class TGST.}

\item{lambda}{A user-specified weight that reflects relative loss for the two types of misdiagnoses, taking value in \eqn{[0,1]}. \eqn{Loss=\lambda*I(FN)+(1-\lambda)*I(FP)}.}

\item{K}{Number of folds in cross validation. The default is 10.}
}
\value{
Cross-validation results.
}
\description{
This function allows you to compute the average of misdiagnoses rate for viral failure and the optimal risk under min-\eqn{\lambda} rules
from K-fold cross-validation.
}
\examples{
d = Simdata
Z = d$Z # True Disease Status
S = d$S # Risk Score
phi = 0.1 #10\% of patients taking viral load test
Obj = TGST(Z, S, phi, method="nonpar")
lambda = 0.8
CV.TGST(Obj, lambda, K=10)
}
\keyword{risk}
\keyword{validation}
