% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{predict.TFRE}
\alias{predict.TFRE}
\title{Make predictions from a 'TFRE' object}
\usage{
\method{predict}{TFRE}(object, newX, s, ...)
}
\arguments{
\item{object}{Fitted "TFRE" model object.}

\item{newX}{Matrix of new values for X at which predictions are to be made.}

\item{s}{Regression model to use for prediction. Should be one of "1st" and
"2nd". See more details in "Details".}

\item{...}{Not used. Other arguments to predict.}
}
\value{
A vector of predictions for the new X values given the fitted TFRE model.
}
\description{
Make predictions for new X values from a fitted TFRE Lasso, SCAD
or MCP model.
}
\details{
If \code{object$second_stage = "none"}, \code{s} cannot be "2nd". If
\code{object$second_stage = "none"} and \code{s = "2nd"}, the function will
return the predictions based on the TFRE Lasso regression. If \code{object$second_stage = "scad"}
or \code{"mcp"}, and \code{s = "2nd"}, the function will return the predictions
based on the TFRE SCAD or MCP regression with the smallest HBIC.
}
\examples{
n <- 20; p <- 50
beta0 <- c(1.5,-1.25,1,-0.75,0.5,rep(0,p-5))
eta_list <- 0.1*6:15*sqrt(log(p)/n)
X <- matrix(rnorm(n*p),n)
y <- X \%*\% beta0 + rt(n,4)
newX <- matrix(rnorm(10*p),10)

\donttest{
Obj_TFRE_Lasso <- TFRE(X, y, second_stage = "none", const_incomplete = 5)
predict(Obj_TFRE_Lasso, newX, "1st")
predict(Obj_TFRE_Lasso, newX, "2nd")}

Obj_TFRE_SCAD <- TFRE(X, y, eta_list = eta_list, const_incomplete = 5)
predict(Obj_TFRE_SCAD, newX, "1st")
predict(Obj_TFRE_SCAD, newX, "2nd")

\donttest{
Obj_TFRE_MCP <- TFRE(X, y, second_stage = "mcp", eta_list = eta_list, const_incomplete = 5)
predict(Obj_TFRE_MCP, newX, "1st")
predict(Obj_TFRE_MCP, newX, "2nd")}

}
\references{
Wang, L., Peng, B., Bradic, J., Li, R. and Wu, Y. (2020),
\emph{A Tuning-free Robust and Efficient Approach to High-dimensional Regression,
Journal of the American Statistical Association, 115:532, 1700-1714},
\doi{10.1080/01621459.2020.1840989}.
}
\seealso{
\code{\link{TFRE}}, \code{\link{coef.TFRE}}, \code{\link{plot.TFRE}}
}
\author{
Yunan Wu and Lan Wang\cr Maintainer:
Yunan Wu <yunan.wu@utdallas.edu>
}
