% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yacht_hydrodynamics_dataset.R
\docType{data}
\name{yacht_hydrodynamics}
\alias{yacht_hydrodynamics}
\title{Yacht Hydrodynamics (Residuary Resistance) Dataset  
 
A dataset for predicting the \strong{residuary resistance} of sailing yachts during early design stages.  
It contains hull geometry, operational parameters, and experimental resistance measurements from the Delft Ship Hydromechanics Laboratory.}
\format{
A data frame with 308 observations (rows) and 7 variables:  
\describe{  
  \item{\code{V1}}{Hull length (\emph{typical unit: meters}). A core geometric parameter that shapes hydrodynamic performance.}  
  \item{\code{V2}}{Hull beam (width) (\emph{typical unit: meters}). Influences the yacht’s stability and resistance properties.}  
  \item{\code{V3}}{Hull draft (\emph{typical unit: meters}). The depth of the hull beneath the waterline, a vital factor for hydrodynamics.}  
  \item{\code{V4}}{Displacement (\emph{typical unit: kilograms or metric tons}). The total mass of the yacht (hull + payload), a key design limitation.}  
  \item{\code{V5}}{Trim angle (\emph{typical unit: degrees}). The longitudinal tilt of the hull, which has an impact on resistance and speed.}  
  \item{\code{V6}}{Boat velocity (\emph{typical unit: m/s or knots}). The speed of the yacht during resistance testing.}  
  \item{\code{V7}}{Residuary resistance (\emph{typical unit: Newtons}). The target variable, representing resistance from wave formation and hull friction (air resistance not included).}  
}
}
\usage{
yacht_hydrodynamics
}
\description{
Yacht Hydrodynamics (Residuary Resistance) Dataset  
 
A dataset for predicting the \strong{residuary resistance} of sailing yachts during early design stages.  
It contains hull geometry, operational parameters, and experimental resistance measurements from the Delft Ship Hydromechanics Laboratory.
}
\examples{
data(yacht_hydrodynamics)  
summary(yacht_hydrodynamics)  
plot(  
  x = yacht_hydrodynamics$V6,  
  y = yacht_hydrodynamics$V7,  
  xlab = "Boat Velocity",  
  ylab = "Residuary Resistance",  
  main = "Velocity vs Residuary Resistance"  
)  
if (requireNamespace("corrplot", quietly = TRUE)) {  
  yacht_corr <- cor(yacht_hydrodynamics, use = "complete.obs")  
  corrplot::corrplot(yacht_corr, method = "color", type = "upper", order = "hclust")  
}  
model <- lm(V7 ~ V6 + V1, data = yacht_hydrodynamics)  
summary(model)  
}
\keyword{datasets}
